/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import kaffe.util.Ptr;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static int threadCount;
    private char[] name;
    private int priority;
    private Thread threadQ;
    private Ptr PrivateInfo;
    private boolean daemon;
    private boolean interrupting;
    private Runnable target;
    private ThreadGroup group;
    private Ptr exceptPtr;
    private Throwable exceptObj;
    private Ptr jnireferences;
    private Throwable stackOverflowError;
    private int needOnStack;
    private boolean dying;
    private Hashtable threadLocals;
    private Object suspendResume;
    private Object finalizeHelper;

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
        System.getSecurityManager().checkAccess(this);
    }

    public native int countStackFrames();

    public static native Thread currentThread();

    public void destroy() {
        if (this.group != null) {
            this.group.remove(this);
        }
        this.destroy0();
    }

    private native void destroy0();

    public static void dumpStack() {
        new Throwable().printStackTrace();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    private final native void finalize0();

    private void finish() {
        if (this.group != null) {
            this.group.remove(this);
        }
    }

    private static String generateName() {
        return new String("Thread-" + threadCount++);
    }

    public final String getName() {
        return new String(this.name);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    Hashtable getThreadLocals() {
        if (this.threadLocals == null) {
            this.threadLocals = new Hashtable();
        }
        return this.threadLocals;
    }

    public void interrupt() {
        this.checkAccess();
        this.interrupting = true;
        this.interrupt0();
    }

    private native void interrupt0();

    public static boolean interrupted() {
        boolean bl = Thread.currentThread().interrupting;
        Thread.currentThread().interrupting = false;
        return bl;
    }

    public final native boolean isAlive();

    public final boolean isDaemon() {
        return this.daemon;
    }

    public boolean isInterrupted() {
        return this.interrupting;
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public final synchronized void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        if (l == 0L && n == 0) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long l2 = System.currentTimeMillis();
            while (this.isAlive() && System.currentTimeMillis() < l + l2) {
                long l3 = l + l2 - System.currentTimeMillis();
                this.wait(l3);
            }
        }
    }

    public final void resume() {
        this.checkAccess();
        if (this.suspendResume != null) {
            Object object = this.suspendResume;
            synchronized (object) {
                this.suspendResume.notifyAll();
            }
        }
    }

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        this.daemon = bl;
    }

    public final void setName(String string) {
        this.checkAccess();
        this.name = string.toCharArray();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n < 1 || n > this.group.getMaxPriority()) {
            throw new IllegalArgumentException();
        }
        this.setPriority0(n);
    }

    private native void setPriority0(int var1);

    public static void sleep(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread.sleep0(l);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static void sleep(long l, int n) throws InterruptedException {
        Thread.sleep(l);
    }

    private static native void sleep0(long var0);

    public synchronized native void start();

    public final void stop() {
        this.stop(new ThreadDeath());
    }

    public final synchronized void stop(Throwable throwable) {
        this.checkAccess();
        this.stop0(throwable);
    }

    private native void stop0(Object var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void suspend() {
        this.checkAccess();
        if (this.suspendResume == null) {
            this.suspendResume = new Object();
        }
        Object object = this.suspendResume;
        synchronized (object) {
            try {
                this.suspendResume.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            return;
        }
    }

    public String toString() {
        return this.getName();
    }

    public static native void yield();

    /* synthetic */ void access$0() {
        this.finalize0();
    }

    public Thread() {
        this(null, null, Thread.generateName());
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.generateName());
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string);
    }

    public Thread(String string) {
        this(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, Thread.generateName());
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        int n;
        int n2;
        Thread thread = this;
        if (thread == null) {
            throw null;
        }
        this.finalizeHelper = new 1(thread);
        Thread thread2 = Thread.currentThread();
        this.group = threadGroup == null ? thread2.getThreadGroup() : threadGroup;
        this.group.checkAccess();
        this.group.add(this);
        this.name = string.toCharArray();
        this.target = runnable;
        this.interrupting = false;
        if (thread2.threadLocals != null) {
            Enumeration enumeration = thread2.threadLocals.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!(object instanceof InheritableThreadLocal)) continue;
                InheritableThreadLocal inheritableThreadLocal = (InheritableThreadLocal)object;
                inheritableThreadLocal.set(this, inheritableThreadLocal.childValue(inheritableThreadLocal.get()));
            }
        }
        this.setPriority0((n2 = thread2.getPriority()) < (n = this.group.getMaxPriority()) ? n2 : n);
        this.setDaemon(thread2.isDaemon());
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string);
    }
}

