/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
implements Serializable {
    private static final long serialVersionUID = 3388685877147921107L;
    private char[] buffer;
    private int used;
    private final int SPARECAPACITY = 16;

    public synchronized StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public synchronized StringBuffer append(String string) {
        if (string == null) {
            string = String.valueOf(string);
        }
        return this.append(string.value, string.offset, string.count);
    }

    public StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public synchronized StringBuffer append(char c) {
        if (this.used + 1 > this.buffer.length) {
            this.ensureCapacity(this.used + 1);
        }
        this.buffer[this.used++] = c;
        return this;
    }

    public synchronized StringBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        if (this.used + n2 > this.buffer.length) {
            this.ensureCapacity(this.used + n2);
        }
        System.arraycopy(cArray, n, this.buffer, this.used, n2);
        this.used += n2;
        return this;
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public int capacity() {
        return this.buffer.length;
    }

    public synchronized char charAt(int n) {
        this.checkIndex(n);
        return this.buffer[n];
    }

    private synchronized void checkIndex(int n) throws StringIndexOutOfBoundsException {
        if (n < 0 || n >= this.used) {
            throw new StringIndexOutOfBoundsException("index = " + n + ", used = " + this.used);
        }
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0 || this.buffer.length > n) {
            return;
        }
        int n2 = this.buffer.length * 2;
        if (n > n2) {
            n2 = n;
        }
        char[] cArray = this.buffer;
        this.buffer = new char[n2];
        System.arraycopy(cArray, 0, this.buffer, 0, this.used);
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        this.checkIndex(n);
        this.checkIndex(n2 - 1);
        System.arraycopy(this.buffer, n, cArray, n3, n2 - n);
    }

    public synchronized StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public synchronized StringBuffer insert(int n, String string) {
        if (string == null) {
            string = String.valueOf(string);
        }
        return this.insert(n, string.toCharArray());
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public synchronized StringBuffer insert(int n, char c) {
        return this.insert(n, String.valueOf(c));
    }

    public synchronized StringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.used + cArray.length);
        System.arraycopy(this.buffer, n, this.buffer, n + cArray.length, this.used - n);
        System.arraycopy(cArray, 0, this.buffer, n, cArray.length);
        this.used += cArray.length;
        return this;
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public int length() {
        return this.used;
    }

    public synchronized StringBuffer reverse() {
        int n = this.used / 2 - 1;
        while (n >= 0) {
            char c = this.buffer[n];
            this.buffer[n] = this.buffer[this.used - n - 1];
            this.buffer[this.used - n - 1] = c;
            --n;
        }
        return this;
    }

    public synchronized void setCharAt(int n, char c) {
        this.checkIndex(n);
        this.buffer[n] = c;
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n > this.used) {
            if (n > this.buffer.length) {
                char[] cArray = this.buffer;
                this.buffer = new char[n];
                System.arraycopy(cArray, 0, this.buffer, 0, this.used);
            } else {
                int n2 = this.used;
                while (n2 < n) {
                    this.buffer[n2] = '\u0000';
                    ++n2;
                }
            }
        }
        this.used = n;
    }

    public String toString() {
        return new String(this);
    }

    public StringBuffer() {
        this.buffer = new char[16];
    }

    public StringBuffer(String string) {
        if (string == null) {
            string = String.valueOf(string);
        }
        this.used = string.length();
        this.buffer = new char[this.used + 16];
        System.arraycopy(string.toCharArray(), 0, this.buffer, 0, this.used);
    }

    public StringBuffer(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        this.buffer = new char[n];
    }
}

