/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import kaffe.io.CharToByteConverter;

public class OutputStreamWriter
extends Writer {
    private static final int BUFDEFAULT = 1024;
    private static final int MINMARGIN = 32;
    private OutputStream strm;
    private CharToByteConverter encoding;
    private byte[] outbuf = new byte[1024];
    private int buflen;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        this.flush();
        try {
            this.strm.close();
            this.strm = null;
            return;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("stream closed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.buflen > 0) {
                    this.strm.write(this.outbuf, 0, this.buflen);
                    this.buflen = 0;
                }
            }
            this.strm.flush();
            return;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("stream closed");
        }
    }

    public String getEncoding() {
        return this.encoding.toString();
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.strm == null) {
            throw new IOException("stream closed");
        }
        Object object = this.lock;
        synchronized (object) {
            while (n2 > 0) {
                int n3 = this.encoding.convert(cArray, n, n2, this.outbuf, this.buflen, this.outbuf.length - this.buflen);
                this.buflen += n3;
                if (n3 == 0 || this.outbuf.length - this.buflen < 32) {
                    this.flush();
                }
                n += n3;
                n2 -= n3;
            }
        }
    }

    public void write(int n) throws IOException {
        this.write(new char[]{(char)n}, 0, 1);
    }

    public OutputStreamWriter(OutputStream outputStream) {
        this.strm = outputStream;
        this.encoding = CharToByteConverter.getDefault();
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.strm = outputStream;
        this.encoding = CharToByteConverter.getConverter(string);
    }
}

