/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OutputStream;
import kaffe.io.ObjectOutputStreamImpl;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private ObjectOutputStreamImpl out;
    private boolean enableReplace = false;
    private Object currentObject;
    private ObjectStreamClass currentStreamClass;

    protected void annotateClass(Class clazz) throws IOException {
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    protected final boolean enableReplaceObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableReplace;
        this.enableReplace = bl;
        return bl2;
    }

    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.out.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.out.writeByte(n);
    }

    public void writeBytes(String string) throws IOException {
        this.out.writeBytes(string);
    }

    public void writeChar(int n) throws IOException {
        this.out.writeChar(n);
    }

    public void writeChars(String string) throws IOException {
        this.out.writeChars(string);
    }

    public void writeDouble(double d) throws IOException {
        this.out.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        this.out.writeFloat(f);
    }

    public void writeInt(int n) throws IOException {
        this.out.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.out.writeLong(l);
    }

    public void writeShort(int n) throws IOException {
        this.out.writeShort(n);
    }

    protected void writeStreamHeader() throws IOException {
        this.out.writeStreamHeader();
    }

    public void writeUTF(String string) throws IOException {
        this.out.writeUTF(string);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void reset() throws IOException {
        this.out.reset();
    }

    protected void drain() throws IOException {
        this.out.drain();
    }

    public final void writeObject(Object object) throws IOException {
        if (this.enableReplace) {
            object = this.replaceObject(object);
        }
        this.out.writeObject(object);
    }

    public final void defaultWriteObject() throws IOException {
        if (this.currentObject == null || this.currentStreamClass == null) {
            throw new NotActiveException();
        }
        this.out.defaultWriteObject(this.currentObject, this.currentStreamClass);
    }

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.out = ObjectStreamClass.factory.newObjectOutputStreamImpl(outputStream, this);
        this.writeStreamHeader();
    }
}

