/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class File
implements Serializable {
    private static final long serialVersionUID = 301077366599181567L;
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    private String path;

    public boolean canRead() {
        this.checkReadAccess();
        return this.exists() && this.canRead0();
    }

    private native boolean canRead0();

    public boolean canWrite() {
        this.checkWriteAccess();
        return this.canWrite0();
    }

    private native boolean canWrite0();

    private void checkReadAccess() {
        System.getSecurityManager().checkRead(this.getPath());
    }

    private void checkWriteAccess() {
        System.getSecurityManager().checkWrite(this.getPath());
    }

    public boolean delete() {
        System.getSecurityManager().checkDelete(this.getPath());
        return this.delete0();
    }

    private native boolean delete0();

    public boolean equals(Object object) {
        if (object != null && object instanceof File) {
            return ((File)object).getPath().equals(this.getPath());
        }
        return false;
    }

    public boolean exists() {
        this.checkReadAccess();
        return this.exists0();
    }

    private native boolean exists0();

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.getPath();
        }
        return System.getProperty("user.dir") + separatorChar + this.getPath();
    }

    public String getCanonicalPath() throws IOException {
        String string = this.getAbsolutePath();
        int n = string.length();
        if (n > 1 && string.charAt(n - 1) == separatorChar) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public String getName() {
        return this.path.substring(this.path.lastIndexOf(separatorChar) + 1);
    }

    public String getParent() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n > 0) {
            return this.path.substring(0, n);
        }
        if (n == 0 && this.path.length() > 1) {
            return separator;
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public native boolean isAbsolute();

    public boolean isDirectory() {
        this.checkReadAccess();
        return this.isDirectory0();
    }

    private native boolean isDirectory0();

    public boolean isFile() {
        this.checkReadAccess();
        return this.isFile0();
    }

    private native boolean isFile0();

    public long lastModified() {
        this.checkReadAccess();
        return this.lastModified0();
    }

    private native long lastModified0();

    public long length() {
        this.checkReadAccess();
        return this.length0();
    }

    private native long length0();

    public String[] list() {
        this.checkReadAccess();
        return this.list0();
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null || filenameFilter == null) {
            return stringArray;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (filenameFilter.accept(this, string)) {
                vector.addElement(string);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File[] listFiles() {
        return this.listFiles(null);
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        String[] stringArray = this.list(filenameFilter);
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(this, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    private native String[] list0();

    public boolean mkdir() {
        this.checkWriteAccess();
        if (this.isDirectory()) {
            return true;
        }
        return this.mkdir0();
    }

    private native boolean mkdir0();

    public boolean mkdirs() {
        File file;
        String string;
        if (!this.toString().equals(separator) && (string = this.getParent()) != null && !(file = new File(string)).mkdirs()) {
            return false;
        }
        return this.mkdir();
    }

    public boolean renameTo(File file) {
        System.getSecurityManager().checkWrite(this.getPath());
        System.getSecurityManager().checkWrite(file.getPath());
        return this.renameTo0(file);
    }

    private native boolean renameTo0(File var1);

    public String toString() {
        return this.path;
    }

    public File(File file, String string) {
        this(file == null ? null : file.getPath(), string);
    }

    public File(String string, String string2) {
        char c;
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.path = string == null ? string2 : (string.length() == 0 ? separatorChar + string2 : ((c = string.charAt(string.length() - 1)) != separatorChar ? string + separatorChar + string2 : string + string2));
    }

    public File(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = string;
    }

    static {
        System.loadLibrary("io");
    }
}

