/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private static final int DEFAULTBUFFERSIZE = 1024;
    private Reader rd;
    private char[] inbuf;
    private int pos;
    private int size;
    private boolean markset;

    public void close() throws IOException {
        this.rd.close();
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray = this.inbuf;
            if (n > this.inbuf.length) {
                this.inbuf = new char[n];
            }
            System.arraycopy(cArray, this.pos, this.inbuf, 0, this.size - this.pos);
            this.size -= this.pos;
            this.pos = 0;
            this.markset = true;
        }
    }

    public boolean markSupported() {
        return true;
    }

    void pushback() {
        --this.pos;
    }

    public int read() throws IOException {
        if (this.pos < this.size || this.refillBuffer() > 0) {
            return this.inbuf[this.pos++];
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos == this.size && !this.markset && n2 >= this.inbuf.length) {
                return this.rd.read(cArray, n, n2);
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                if (this.pos == this.size) {
                    if (n3 > 0 && !this.rd.ready()) {
                        return n3;
                    }
                    if (this.refillBuffer() <= 0) {
                        if (n3 <= 0) return -1;
                        int n5 = n3;
                        return n5;
                    }
                }
                if ((n4 = n2 - n3) > this.size) {
                    n4 = this.size;
                }
                System.arraycopy(this.inbuf, this.pos, cArray, n, n4);
                this.pos += n4;
                n += n4;
                n3 += n4;
            }
            return n3;
        }
    }

    public String readLine() throws IOException {
        int n = this.pos;
        int n2 = 32;
        String string = null;
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.pos < this.size && (n2 = this.inbuf[this.pos]) != 10 && n2 != 13) {
                    ++this.pos;
                    continue;
                }
                if (this.pos != this.size) break;
                if (this.pos > n) {
                    string = string == null ? new String(this.inbuf, n, this.pos - n) : string + new String(this.inbuf, n, this.pos - n);
                }
                if (this.refillBuffer() <= 0) {
                    String string2 = string;
                    Object var5_7 = null;
                    return string2;
                }
                n = 0;
            }
            string = string == null ? new String(this.inbuf, n, this.pos - n) : string + new String(this.inbuf, n, this.pos - n);
            ++this.pos;
            if (n2 == 13 && this.read() != 10 && this.pos > 0) {
                --this.pos;
            }
            String string3 = string;
            Object var5_8 = null;
            return string3;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.pos < this.size || this.rd.ready();
            Object var2_3 = null;
            return bl;
        }
    }

    private int refillBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = this.rd.read(this.inbuf, 0, this.inbuf.length);
            this.pos = 0;
            this.markset = false;
            if (n > 0) {
                this.size = n;
                int n2 = n;
                Object var2_5 = null;
                return n2;
            }
            this.size = 0;
            int n3 = -1;
            Object var2_6 = null;
            return n3;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.markset) {
                throw new IOException("invalid mark");
            }
            this.pos = 0;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long l2 = this.size - this.pos;
            if (l2 > l) {
                l2 = l;
            }
            this.pos += (int)l2;
            if (l2 == l) {
                long l3 = l;
                Object var4_6 = null;
                return l3;
            }
            this.pos = 0;
            this.size = 0;
            this.markset = false;
            long l4 = l2 + this.rd.skip(l - l2);
            Object var4_7 = null;
            return l4;
        }
    }

    public BufferedReader(Reader reader) {
        this(reader, 1024);
    }

    public BufferedReader(Reader reader, int n) {
        this.rd = reader;
        this.inbuf = new char[n];
        this.pos = 0;
        this.size = 0;
        this.markset = false;
    }
}

