/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    private static final int DEFAULTBUFFER = 2048;
    protected byte[] buf;
    protected int count;

    private void writeBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
        }
        this.count = 0;
    }

    public synchronized void flush() throws IOException {
        this.writeBuffer();
        this.out.flush();
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        while (this.count + n2 > this.buf.length) {
            int n3 = this.buf.length - this.count;
            System.arraycopy(byArray, n, this.buf, this.count, n3);
            this.count += n3;
            this.writeBuffer();
            n += n3;
            n2 -= n3;
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public synchronized void write(int n) throws IOException {
        if (this.count == this.buf.length) {
            this.writeBuffer();
        }
        this.buf[this.count++] = (byte)n;
    }

    public BufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 2048);
    }

    public BufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.buf = new byte[n];
        this.count = 0;
    }
}

