/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DataFlavor
implements Externalizable {
    public static DataFlavor plainTextFlavor = null;
    public static DataFlavor stringFlavor = null;
    static Class defaultRepClass;
    static String defaultMimeType;
    private static final long serialVersionUID = 8367026044764648243L;
    String type;
    String name;
    Class repClass;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public boolean equals(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor) && this.repClass == dataFlavor.repClass;
    }

    public String getHumanPresentableName() {
        return this.name;
    }

    public String getMimeType() {
        return this.type;
    }

    public Class getRepresentationClass() {
        return this.repClass;
    }

    public boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.type);
    }

    public boolean isMimeTypeEqual(String string) {
        return this.type.equals(string);
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return string + '=' + string2;
    }

    public void setHumanPresentableName(String string) {
        this.name = string;
    }

    public String toString() {
        return "DataFlavor [" + this.name + ',' + this.type + ',' + this.repClass.getName() + ']';
    }

    public DataFlavor(Class clazz, String string) {
        this.type = defaultMimeType;
        this.repClass = clazz;
        this.name = string;
    }

    public DataFlavor(String string, String string2) {
        this.repClass = defaultRepClass;
        this.type = string;
        this.name = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            defaultRepClass = Class.forName("java.io.InputStream");
            defaultMimeType = "application/x-java-serialized-object";
            plainTextFlavor = new DataFlavor("text/plain; charset=unicode", "plain text");
            stringFlavor = new DataFlavor(Class.forName("java.lang.String"), "unicode string");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

