/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.NativeSelection;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import kaffe.awt.ExportTransferable;
import kaffe.util.Ptr;

class NativeClipboard
extends Clipboard {
    static NativeClipboard singleton;
    Ptr nativeData = Toolkit.cbdInitClipboard();

    static Transferable createTransferable(String string, byte[] byArray) {
        return new NativeSelection(string, byArray);
    }

    void dispose() {
        if (this.nativeData != null) {
            Toolkit.cbdFreeClipboard(this.nativeData);
            this.nativeData = null;
        }
    }

    public Transferable getContents(Object object) {
        if (this.owner != null) {
            return this.contents;
        }
        return Toolkit.cbdGetContents(this.nativeData);
    }

    static byte[] getNativeData(String string) {
        Transferable transferable = NativeClipboard.singleton.contents;
        if (transferable != null && transferable instanceof ExportTransferable) {
            return ((ExportTransferable)transferable).getNativeData(string);
        }
        return null;
    }

    static void lostOwnership() {
        if (NativeClipboard.singleton.owner != null) {
            NativeClipboard.singleton.owner.lostOwnership(singleton, NativeClipboard.singleton.contents);
            NativeClipboard.singleton.owner = null;
            NativeClipboard.singleton.contents = null;
        }
    }

    public void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (this.owner != null) {
            if (this.owner != clipboardOwner) {
                this.owner.lostOwnership(this, this.contents);
                this.owner = clipboardOwner;
            }
            this.contents = transferable;
        } else {
            Toolkit.startDispatch();
            if (Toolkit.cbdSetOwner(this.nativeData)) {
                this.owner = clipboardOwner;
                this.contents = transferable;
            }
        }
    }

    NativeClipboard() {
        super("System");
        singleton = this;
    }
}

