/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Image;
import java.awt.ImageNativeProducer;
import java.awt.Toolkit;
import kaffe.util.Ptr;

class ImageFrameLoader
extends Thread {
    Image img;

    public void run() {
        if (!(this.img.producer instanceof ImageNativeProducer)) {
            while (true) {
                // Infinite loop
            }
        }
        this.runINPLoop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runINPLoop() {
        do {
            Image image = this.img;
            synchronized (image) {
                try {
                    while ((this.img.flags & 0x800) != 0) {
                        this.img.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            int n = Toolkit.imgGetLatency(this.img.nativeData);
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
            }
            Ptr ptr = Toolkit.imgGetNextFrame(this.img.nativeData);
            if (ptr == null) {
                return;
            }
            this.img.nativeData = ptr;
            int n2 = Toolkit.imgGetWidth(this.img.nativeData);
            int n3 = Toolkit.imgGetHeight(this.img.nativeData);
            if (this.img.width != n2 || this.img.height != n3) {
                this.img.width = n2;
                this.img.height = n3;
                this.img.stateChange(3, 0, 0, this.img.width, this.img.height);
            }
            this.img.flags |= 0x800;
            this.img.stateChange(16, 0, 0, this.img.width, this.img.height);
        } while (this.img.observers != null);
    }

    ImageFrameLoader(Image image) {
        this.img = image;
        image.flags |= 0x800;
        this.setPriority(2);
        this.start();
    }
}

