/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import kaffe.util.NotImplemented;

public class GridBagLayout
implements LayoutManager2,
Serializable {
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int ACTUALSIZE = 3;
    protected static final int MAXGRIDSIZE = 512;
    private static final long serialVersionUID = 8838754796412211005L;
    protected Hashtable comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    transient Point offset = new Point();

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        throw new NotImplemented();
    }

    protected void ArrangeGrid(Container container) {
        this.layoutContainer(container);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addLayoutComponent(Component component, Object object) {
        try {
            if (object == null) return;
            this.setConstraints(component, (GridBagConstraints)object);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("not GridBagConstraints");
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    void adjustWeightsRelative(Container container) {
        int n;
        double d;
        int n2;
        Insets insets = container.getInsets();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.sumWidths();
        int n6 = this.sumHeights();
        double d2 = 0.0;
        double d3 = 0.0;
        int n7 = 0;
        while (n7 < this.columnWeights.length) {
            if (this.columnWeights[n7] > 0.0) {
                d2 += this.columnWeights[n7];
                ++n3;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < this.rowWeights.length) {
            if (this.rowWeights[n7] > 0.0) {
                d3 += this.rowWeights[n7];
                ++n4;
            }
            ++n7;
        }
        int n8 = insets.left + insets.right;
        int n9 = insets.top + insets.bottom;
        if (n3 > 0) {
            n2 = container.width - n5 - n8;
            n7 = 0;
            while (n7 < this.columnWeights.length) {
                d = this.columnWeights[n7];
                if (d > 0.0) {
                    n = (int)(d / d2 * (double)n2);
                    int n10 = n7;
                    this.columnWidths[n10] = this.columnWidths[n10] + n;
                    d2 -= d;
                    n2 -= n;
                }
                if (d2 == 0.0) break;
                ++n7;
            }
            if (n2 > 0) {
                int n11 = n7;
                this.columnWidths[n11] = this.columnWidths[n11] + n2;
            }
            this.offset.x = 0;
        } else {
            this.offset.x = (container.width - n5 - n8) / 2;
        }
        if (n4 > 0) {
            n2 = container.height - n6 - n9;
            n7 = 0;
            while (n7 < this.rowWeights.length) {
                d = this.rowWeights[n7];
                if (d > 0.0) {
                    n = (int)(d / d3 * (double)n2);
                    int n12 = n7;
                    this.rowHeights[n12] = this.rowHeights[n12] + n;
                    d3 -= d;
                    n2 -= n;
                }
                if (d3 == 0.0) break;
                ++n7;
            }
            if (n2 > 0) {
                int n13 = n7;
                this.rowHeights[n13] = this.rowHeights[n13] + n2;
            }
            this.offset.y = 0;
        } else {
            this.offset.y = (container.height - n6 - n9) / 2;
        }
    }

    int columnStart(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.columnWidths[n3];
            ++n3;
        }
        return n2;
    }

    void dumpDims() {
        System.out.print("\t");
        int n = 0;
        while (n < this.columnWidths.length) {
            System.out.print(this.columnWidths[n] + " ");
            ++n;
        }
        System.out.println();
        n = 0;
        while (n < this.rowHeights.length) {
            System.out.println(this.rowHeights[n]);
            ++n;
        }
    }

    void dumpWeights() {
        System.out.print("\t");
        int n = 0;
        while (n < this.columnWeights.length) {
            System.out.print(this.columnWeights[n] + " ");
            ++n;
        }
        System.out.println();
        n = 0;
        while (n < this.rowWeights.length) {
            System.out.println(this.rowWeights[n]);
            ++n;
        }
    }

    void getCellDims(Container container, int n) {
        Dimension dimension = this.getLayoutExtends(container);
        int n2 = -1;
        int n3 = 0;
        int n4 = container.getComponentCount();
        this.rowHeights = new int[dimension.height];
        this.columnWidths = new int[dimension.width];
        this.columnWeights = new double[dimension.width];
        this.rowWeights = new double[dimension.height];
        int n5 = 0;
        while (n5 < n4) {
            Component component = container.getComponent(n5);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            Dimension dimension2 = n == 1 ? component.getMinimumSize() : component.getPreferredSize();
            n2 = gridBagConstraints.gridx == -1 ? ++n2 : gridBagConstraints.gridx;
            if (gridBagConstraints.gridy > -1) {
                n3 = gridBagConstraints.gridy;
            }
            int n6 = dimension2.width + gridBagConstraints.insets.left + gridBagConstraints.insets.right + 2 * gridBagConstraints.ipadx;
            int n7 = dimension2.height + gridBagConstraints.insets.top + gridBagConstraints.insets.bottom + 2 * gridBagConstraints.ipady;
            int n8 = gridBagConstraints.gridwidth;
            int n9 = gridBagConstraints.gridheight;
            if (n8 == 0) {
                n8 = dimension.width - n2;
            } else if (n8 == -1) {
                n8 = dimension.width - n2 - 1;
            }
            if (n9 == 0) {
                n9 = dimension.height - n3;
            } else if (n9 == -1) {
                n9 = dimension.height - n3 - 1;
            }
            if (n8 < 1) {
                n8 = 1;
            }
            if (n9 < 1) {
                n9 = 1;
            }
            n6 /= n8;
            n7 /= n9;
            int n10 = 0;
            while (n10 < n8) {
                if (this.columnWidths[n2 + n10] < n6) {
                    this.columnWidths[n2 + n10] = n6;
                }
                ++n10;
            }
            if (this.columnWeights[n2 + n8 - 1] < gridBagConstraints.weightx) {
                this.columnWeights[n2 + n8 - 1] = gridBagConstraints.weightx;
            }
            n10 = 0;
            while (n10 < n9) {
                if (this.rowHeights[n3 + n10] < n7) {
                    this.rowHeights[n3 + n10] = n7;
                }
                ++n10;
            }
            if (this.rowWeights[n3 + n9 - 1] < gridBagConstraints.weighty) {
                this.rowWeights[n3 + n9 - 1] = gridBagConstraints.weighty;
            }
            n2 += n8 - 1;
            if (gridBagConstraints.gridwidth == 0) {
                ++n3;
                n2 = -1;
            }
            ++n5;
        }
        if (n == 3) {
            this.adjustWeightsRelative(container);
        }
    }

    public GridBagConstraints getConstraints(Component component) {
        return (GridBagConstraints)this.lookupConstraints(component).clone();
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public int[][] getLayoutDimensions() {
        return new int[][]{this.columnWidths, this.rowHeights};
    }

    Dimension getLayoutExtends(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = container.getComponentCount();
        int n6 = 0;
        while (n6 < n5) {
            Component component = container.getComponent(n6);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            n3 = gridBagConstraints.gridx >= 0 ? gridBagConstraints.gridx : ++n3;
            if (gridBagConstraints.gridy >= 0) {
                n4 = gridBagConstraints.gridy;
            }
            switch (gridBagConstraints.gridwidth) {
                case 0: {
                    if (n < n3) {
                        n = n3;
                    }
                    n3 = -1;
                    ++n4;
                    break;
                }
                case -1: {
                    if (n >= n3) break;
                    n = n3;
                    break;
                }
                default: {
                    if (n >= (n3 += gridBagConstraints.gridwidth - 1)) break;
                    n = n3;
                    break;
                }
            }
            switch (gridBagConstraints.gridheight) {
                case -1: 
                case 0: {
                    break;
                }
                default: {
                    if (n3 == -1 || n2 >= n4 + gridBagConstraints.gridheight) break;
                    n2 = n4 + gridBagConstraints.gridheight;
                    break;
                }
            }
            ++n6;
        }
        return new Dimension(n + 1, Math.max(n2, n4));
    }

    public Point getLayoutOrigin() {
        return this.offset;
    }

    public double[][] getLayoutWeights() {
        return new double[][]{this.columnWeights, this.rowWeights};
    }

    public void invalidateLayout(Container container) {
        this.layoutContainer(container);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = -1;
        int n2 = 0;
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = 0;
        int n6 = 0;
        Rectangle rectangle = new Rectangle();
        int n7 = container.getComponentCount();
        this.getCellDims(container, 3);
        int n8 = 0;
        while (n8 < n7) {
            Component component = container.getComponent(n8);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            boolean bl = false;
            if (gridBagConstraints.gridy >= 0) {
                n2 = gridBagConstraints.gridy;
                n4 = this.rowStart(n2) + insets.top;
            }
            if (gridBagConstraints.gridx < 0) {
                ++n;
                if (n2 > rectangle.y) {
                    n += rectangle.x + rectangle.width;
                }
                n3 = this.columnStart(n) + insets.left;
            } else {
                n = gridBagConstraints.gridx;
                n3 = this.columnStart(n) + insets.left;
            }
            int n9 = gridBagConstraints.gridwidth;
            if (n9 == 0) {
                n9 = this.columnWidths.length - n;
                bl = true;
            } else if (n9 == -1) {
                n9 = this.columnWidths.length - n - 1;
            }
            int n10 = gridBagConstraints.gridheight;
            if (n10 == 0) {
                n10 = this.rowHeights.length - n2;
            } else if (n10 == -1) {
                n10 = this.rowHeights.length - n2 - 1;
            }
            n5 = 0;
            int n11 = 0;
            while (n11 < n9) {
                n5 += this.columnWidths[n++];
                ++n11;
            }
            --n;
            n6 = 0;
            n11 = 0;
            while (n11 < n10) {
                n6 += this.rowHeights[n2 + n11];
                ++n11;
            }
            if (n10 > 1) {
                rectangle.setBounds(n, n2, n9, n10);
            } else if (n2 >= rectangle.y + rectangle.height) {
                rectangle.setBounds(0, 0, 0, 0);
            }
            Insets insets2 = gridBagConstraints.insets;
            Dimension dimension = component.getPreferredSize();
            int n12 = n3 + this.offset.x;
            int n13 = n4 + this.offset.y;
            int n14 = dimension.width;
            int n15 = dimension.height;
            block0 : switch (gridBagConstraints.fill) {
                case 1: {
                    n12 += insets2.left + gridBagConstraints.ipadx;
                    n13 += insets2.top + gridBagConstraints.ipady;
                    n14 = n5 - (insets2.left + insets2.right + 2 * gridBagConstraints.ipadx);
                    n15 = n6 - (insets2.top + insets2.bottom + 2 * gridBagConstraints.ipady);
                    break;
                }
                case 2: {
                    n12 += insets2.left + gridBagConstraints.ipadx;
                    n14 = n5 - (insets2.left + insets2.right + 2 * gridBagConstraints.ipadx);
                    switch (gridBagConstraints.anchor) {
                        default: {
                            n13 += (n6 - n15) / 2;
                            break block0;
                        }
                        case 11: 
                        case 12: 
                        case 18: {
                            n13 += insets2.top + gridBagConstraints.ipady;
                            break block0;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                    }
                    n13 += n6 - (dimension.height + insets2.bottom + gridBagConstraints.ipady);
                    break;
                }
                case 3: {
                    n13 += insets2.top + gridBagConstraints.ipady;
                    n14 = n6 - (insets2.top + insets2.bottom + 2 * gridBagConstraints.ipady);
                    switch (gridBagConstraints.anchor) {
                        default: {
                            n12 += (n5 - n14) / 2;
                            break block0;
                        }
                        case 16: 
                        case 17: 
                        case 18: {
                            n12 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 12: 
                        case 13: 
                        case 14: 
                    }
                    n12 += n5 - (n14 + insets2.right + gridBagConstraints.ipadx);
                    break;
                }
                default: {
                    switch (gridBagConstraints.anchor) {
                        case 11: {
                            n13 += insets2.top + gridBagConstraints.ipady;
                            n12 += (n5 - n14) / 2;
                            break block0;
                        }
                        case 12: {
                            n13 += insets2.top + gridBagConstraints.ipady;
                            n12 += n5 - (n14 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 13: {
                            n13 += (n6 - n15) / 2;
                            n12 += n5 - (n14 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 14: {
                            n13 += n6 - (n15 + insets2.bottom + gridBagConstraints.ipady);
                            n12 += n5 - (n14 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 15: {
                            n13 += n6 - (n15 + insets2.bottom + gridBagConstraints.ipady);
                            n12 += (n5 - n14) / 2;
                            break block0;
                        }
                        case 16: {
                            n13 += n6 - (n15 + insets2.bottom + gridBagConstraints.ipady);
                            n12 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 17: {
                            n13 += (n6 - n15) / 2;
                            n12 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 18: {
                            n13 += insets2.top + gridBagConstraints.ipady;
                            n12 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                    }
                    n13 += (n6 - n15) / 2;
                    n12 += (n5 - n14) / 2;
                    break;
                }
            }
            component.setBounds(n12, n13, n14, n15);
            if (bl) {
                n = -1;
                n4 += n6;
                ++n2;
            }
            ++n8;
        }
    }

    public Point location(int n, int n2) {
        int n3 = this.offset.x;
        int n4 = this.offset.y;
        int n5 = 0;
        while (n5 < this.columnWidths.length) {
            if (n < (n3 += this.columnWidths[n5])) break;
            ++n5;
        }
        int n6 = 0;
        while (n5 < this.rowHeights.length) {
            if (n2 < (n4 += this.rowHeights[n6])) break;
            ++n6;
        }
        return new Point(n5, n6);
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        if (gridBagConstraints == null) {
            gridBagConstraints = this.defaultConstraints;
        }
        return gridBagConstraints;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getCellDims(container, 1);
        return new Dimension(this.sumWidths() + insets.left + insets.right, this.sumHeights() + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getCellDims(container, 2);
        return new Dimension(this.sumWidths() + insets.left + insets.right, this.sumHeights() + insets.top + insets.bottom);
    }

    public void removeLayoutComponent(Component component) {
        this.comptable.remove(component);
    }

    int rowStart(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.rowHeights[n3];
            ++n3;
        }
        return n2;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.comptable.put(component, (GridBagConstraints)gridBagConstraints.clone());
    }

    int sumHeights() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rowHeights.length) {
            n += this.rowHeights[n2];
            ++n2;
        }
        return n;
    }

    int sumWidths() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.columnWidths.length) {
            n += this.columnWidths[n2];
            ++n2;
        }
        return n;
    }

    public String toString() {
        int n = this.columnWidths != null ? this.columnWidths.length : 0;
        int n2 = this.rowHeights != null ? this.rowHeights.length : 0;
        return "GridBagLayout columns: " + n + ",rows: " + n2;
    }
}

