/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ClassProperties;
import java.lang.reflect.Method;
import java.util.Hashtable;

class ClassAnalyzer {
    static Hashtable dict = new Hashtable();
    static Class[] sig_AWTEvent = new Class[]{class$Ljava$awt$AWTEvent != null ? class$Ljava$awt$AWTEvent : (class$Ljava$awt$AWTEvent = ClassAnalyzer.class$("java.awt.AWTEvent"))};
    static Class[] sig_Event = new Class[]{class$Ljava$awt$Event != null ? class$Ljava$awt$Event : (class$Ljava$awt$Event = ClassAnalyzer.class$("java.awt.Event"))};
    static Class[] sig_Event_Object = new Class[]{class$Ljava$awt$Event != null ? class$Ljava$awt$Event : (class$Ljava$awt$Event = ClassAnalyzer.class$("java.awt.Event")), class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ClassAnalyzer.class$("java.lang.Object"))};
    static Class[] sig_Event_int = new Class[]{class$Ljava$awt$Event != null ? class$Ljava$awt$Event : (class$Ljava$awt$Event = ClassAnalyzer.class$("java.awt.Event")), Integer.TYPE};
    static Class[] sig_Event_int_int = new Class[]{class$Ljava$awt$Event != null ? class$Ljava$awt$Event : (class$Ljava$awt$Event = ClassAnalyzer.class$("java.awt.Event")), Integer.TYPE, Integer.TYPE};
    static String[] oldEventMethodName = new String[]{"handleEvent", "action", "keyDown", "keyUp", "mouseDown", "mouseUp", "mouseMove", "gotFocus", "lostFocus", "mouseEnter", "mouseExit", "mouseDrag", "postEvent"};
    static Class[][] oldEventMethodSig = new Class[][]{sig_Event, sig_Event_Object, sig_Event_int, sig_Event_int, sig_Event_int_int, sig_Event_int_int, sig_Event_int_int, sig_Event_Object, sig_Event_Object, sig_Event_int_int, sig_Event_int_int, sig_Event_int_int, sig_Event};
    private static /* synthetic */ Class class$Ljava$awt$AWTEvent;
    private static /* synthetic */ Class class$Ljava$awt$Event;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$awt$MenuComponent;
    private static /* synthetic */ Class class$Ljava$awt$Component;

    static ClassProperties analyzeAll(Class clazz, boolean bl) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.hasProcessEvent = ClassAnalyzer.checkProcessEvent(clazz);
            classProperties.useOldEvents = bl ? ClassAnalyzer.checkOldEventMethods(clazz) : false;
            classProperties.isNativeLike = bl;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    static ClassProperties analyzePostEvent(Class clazz) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.useOldEvents = ClassAnalyzer.checkOldEventMenuMethods(clazz);
            classProperties.hasProcessEvent = false;
            classProperties.isNativeLike = false;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    static ClassProperties analyzeProcessEvent(Class clazz, boolean bl) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.useOldEvents = false;
            classProperties.hasProcessEvent = ClassAnalyzer.checkProcessEvent(clazz);
            classProperties.isNativeLike = bl;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean checkOldEventMenuMethods(Class clazz) {
        try {
            Method method = clazz.getMethod("postEvent", sig_Event);
            if (method.getDeclaringClass() == (class$Ljava$awt$MenuComponent != null ? class$Ljava$awt$MenuComponent : (class$Ljava$awt$MenuComponent = ClassAnalyzer.class$("java.awt.MenuComponent")))) return false;
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("ouch!! " + clazz + " has no postEvent");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean checkOldEventMethods(Class clazz) {
        int n = 0;
        try {
            n = 0;
            while (true) {
                if (n >= oldEventMethodName.length) {
                    return false;
                }
                Method method = clazz.getMethod(oldEventMethodName[n], oldEventMethodSig[n]);
                if (method.getDeclaringClass() != (class$Ljava$awt$Component != null ? class$Ljava$awt$Component : ClassAnalyzer.class$("java.awt.Component"))) {
                    return true;
                }
                ++n;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("ouch!! " + clazz + " has no " + oldEventMethodName[n]);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean checkProcessEvent(Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("processEvent", sig_AWTEvent);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    ClassAnalyzer() {
    }
}

