/*
 * Decompiled with CFR 0.152.
 */
package pizza.v39;

import java.io.IOException;
import pizza.support.array;
import pizza.v39.AST;
import pizza.v39.AccessError;
import pizza.v39.AmbiguityError;
import pizza.v39.Basic;
import pizza.v39.ClassSymbol;
import pizza.v39.Constants;
import pizza.v39.ContextInfo;
import pizza.v39.Env;
import pizza.v39.LoadError;
import pizza.v39.Mangle;
import pizza.v39.Name;
import pizza.v39.NameError;
import pizza.v39.Report;
import pizza.v39.ResolveError;
import pizza.v39.Scope;
import pizza.v39.Switches;
import pizza.v39.Symbol;
import pizza.v39.Symtab;
import pizza.v39.Type;
import pizza.v39.TypeSymbol;

class Namer
implements Constants {
    static Name[] opname = new Name[32];

    static boolean accessible(Env env, TypeSymbol typeSymbol) {
        return (typeSymbol.modifiers & 1) != 0 || env != null && (env.toplevel.packge == typeSymbol.owner || env.toplevel.packge == typeSymbol.outermostClass().owner);
    }

    static boolean accessible(Env env, TypeSymbol typeSymbol, Symbol symbol) {
        if (symbol.name == Basic.initS && symbol.owner.fullName() != typeSymbol.fullname) {
            return false;
        }
        int n = symbol.modifiers;
        switch (n & 7) {
            case 2: {
                return env.enclClass.sym == symbol.owner || env.enclClass.sym.outermostClass() == symbol.owner.outermostClass();
            }
            case 0: {
                return env.toplevel.packge == symbol.owner.owner || env.toplevel.packge == symbol.outermostClass().owner;
            }
            case 4: {
                return env.toplevel.packge == symbol.owner.owner || env.toplevel.packge == symbol.outermostClass().owner || env.enclClass.sym.subclass(symbol.owner) && (typeSymbol.subclass(env.enclClass.sym) || ((ContextInfo)env.info).selectSuper);
            }
        }
        return Namer.accessible(env, typeSymbol);
    }

    static Type symType(Type type, Symbol symbol, boolean bl) {
        Type type2 = symbol.owner != null && symbol.owner.kind == 2 && (symbol.modifiers & 8) == 0 && !symbol.isTypeVar() ? type.memberType(symbol) : symbol.type;
        return type2.newInstance(bl);
    }

    static Type symType(Type type, Symbol symbol) {
        return Namer.symType(type, symbol, false);
    }

    static boolean instantiatable(Symbol symbol, Type[] typeArray, Type type) {
        Type type2 = Namer.symType(type, symbol);
        switch (type2.pizza$v39$Type$$tag) {
            case 5: {
                Type[] typeArray2 = ((Type.FunType)type2).argtypes;
                return typeArray == null || Type.subtypes(typeArray, typeArray2);
            }
        }
        return false;
    }

    static boolean asGood(Env env, Type type, Symbol symbol, Symbol symbol2) {
        return !Namer.accessible(env, type.tsym(), symbol2) || Namer.accessible(env, type.tsym(), symbol) && (((symbol.modifiers | symbol2.modifiers) & 8) != 0 || ((symbol.owner.modifiers | symbol2.owner.modifiers) & 0x200) != 0 || symbol.owner.subclass(symbol2.owner)) && Namer.instantiatable(symbol2, Namer.symType(type, symbol, true).argtypes(), type);
    }

    static Symbol findField(Env env, TypeSymbol typeSymbol, Name name) {
        Constants constants = NameError.varNotFound;
        Symbol symbol = typeSymbol.locals().lookup(name);
        while (symbol.scope != null) {
            if (symbol.sym.kind == 4) {
                if (Namer.accessible(env, typeSymbol, symbol.sym)) {
                    return symbol.sym;
                }
                if (constants.kind > 258) {
                    constants = new AccessError(symbol.sym);
                }
            }
            symbol = symbol.next();
        }
        while (true) {
            Constants constants2;
            Type[] typeArray = typeSymbol.interfaces();
            for (int i = 0; i < typeArray.length; ++i) {
                constants2 = Namer.findField(env, typeArray[i].tsym(), name);
                if (constants.kind < 256 && ((Symbol)constants2).kind < 256 && constants.owner != ((Symbol)constants2).owner) {
                    return new AmbiguityError((Symbol)constants, (Symbol)constants2);
                }
                if (((Symbol)constants2).kind == 256) {
                    return constants2;
                }
                if (((Symbol)constants2).kind >= constants.kind) continue;
                constants = constants2;
            }
            constants2 = typeSymbol.supertype();
            if (constants.kind < 256 || constants2 == null) {
                return constants;
            }
            typeSymbol = ((Type)constants2).tsym();
        }
    }

    static Symbol findImportedField(Env env, Scope scope, Name name) {
        Symbol symbol = scope.lookup(name);
        while (!(symbol.scope == null || symbol.sym.kind == 4 && Namer.accessible(env, (TypeSymbol)symbol.sym.owner, symbol.sym))) {
            symbol = symbol.next();
        }
        if (symbol.scope != null) {
            Symbol symbol2 = symbol.next();
            while (!(symbol2.scope == null || symbol2.sym.kind == 4 && Namer.accessible(env, (TypeSymbol)symbol2.sym.owner, symbol2.sym))) {
                symbol2 = symbol2.next();
            }
            if (symbol2.scope != null) {
                return new AmbiguityError(symbol.sym, symbol2.sym);
            }
            return symbol.sym;
        }
        return NameError.varNotFound;
    }

    static Symbol findVar(Env env, Name name) {
        Symbol symbol;
        Symbol symbol2 = NameError.varNotFound;
        Env env2 = env;
        do {
            Symbol symbol3 = ((ContextInfo)env2.info).scope.lookup(name);
            while (symbol3.scope != null) {
                if (symbol3.sym.kind == 4) {
                    return symbol3.sym;
                }
                symbol3 = symbol3.next();
            }
            symbol = Namer.findField(env2, env2.enclClass.sym, name);
            if (symbol.kind < 256) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            env2 = env2.outer;
        } while (env2.outer != null);
        symbol = Namer.findImportedField(env, env.toplevel.namedImportScope, name);
        if (symbol.kind < 256) {
            return symbol;
        }
        if (symbol.kind < symbol2.kind) {
            symbol2 = symbol;
        }
        symbol = Namer.findImportedField(env, env.toplevel.starImportScope, name);
        if (symbol.kind < 256) {
            return symbol;
        }
        if (symbol.kind < symbol2.kind) {
            symbol2 = symbol;
        }
        symbol = Namer.findField(env, Symbol.predefClass, name);
        if (symbol.kind < 256) {
            return symbol;
        }
        return symbol2;
    }

    static Symbol findAbstractMethod(Env env, TypeSymbol typeSymbol, Symbol symbol, Name name, Type[] typeArray, Type type) {
        Symbol symbol2 = typeSymbol.locals().lookup(name);
        while (symbol2.scope != null) {
            if (Namer.instantiatable(symbol2.sym, typeArray, type) && (symbol.kind >= 256 || !Namer.asGood(env, type, symbol, symbol2.sym))) {
                symbol = symbol2.sym;
            }
            symbol2 = symbol2.next();
        }
        while (true) {
            Type[] typeArray2 = typeSymbol.interfaces();
            for (int i = 0; i < typeArray2.length; ++i) {
                symbol = Namer.findAbstractMethod(env, typeArray2[i].tsym(), symbol, name, typeArray, type);
            }
            Type type2 = typeSymbol.supertype();
            if (type2 == null) {
                return symbol;
            }
            typeSymbol = type2.tsym();
        }
    }

    static Symbol checkBestAbstractMethod(Env env, TypeSymbol typeSymbol, Symbol symbol, Type[] typeArray, Type type) {
        Symbol symbol2 = typeSymbol.locals().lookup(symbol.name);
        while (symbol2.scope != null) {
            if (symbol != symbol2.sym && Namer.instantiatable(symbol2.sym, typeArray, type) && !Namer.asGood(env, type, symbol, symbol2.sym) && !Type.erroneous(typeArray)) {
                return new AmbiguityError(symbol, symbol2.sym);
            }
            symbol2 = symbol2.next();
        }
        while (true) {
            Type[] typeArray2 = typeSymbol.interfaces();
            for (int i = 0; symbol.kind == 8 && i < typeArray2.length; ++i) {
                symbol = Namer.checkBestAbstractMethod(env, typeArray2[i].tsym(), symbol, typeArray, type);
            }
            Type type2 = typeSymbol.supertype();
            if (type2 == null) {
                if (symbol.kind >= 256 || Namer.accessible(env, type.tsym(), symbol)) {
                    return symbol;
                }
                return new AccessError(symbol);
            }
            typeSymbol = type2.tsym();
        }
    }

    static Symbol findBestMethod(Env env, Type type, Symbol symbol, Type[] typeArray) {
        Symbol symbol2 = symbol.sym;
        Symbol symbol3 = symbol.next();
        while (symbol3.scope != null) {
            if (Namer.instantiatable(symbol3.sym, typeArray, type) && !Namer.asGood(env, type, symbol2, symbol3.sym)) {
                symbol2 = symbol3.sym;
            }
            symbol3 = symbol3.next();
        }
        if (symbol2 != symbol.sym) {
            symbol3 = symbol;
            while (symbol3.scope != null) {
                if (symbol2 != symbol3.sym && Namer.instantiatable(symbol3.sym, typeArray, type) && !Namer.asGood(env, type, symbol2, symbol3.sym) && !Type.erroneous(typeArray)) {
                    return new AmbiguityError(symbol2, symbol3.sym);
                }
                symbol3 = symbol3.next();
            }
        }
        if (symbol2.kind >= 256 || Namer.accessible(env, type.tsym(), symbol2)) {
            return symbol2;
        }
        return new AccessError(symbol2);
    }

    static Symbol findMethod(Env env, Type type, Name name, Type[] typeArray) {
        if ((type.tsym().modifiers & 0x600) != 0) {
            Symbol symbol = Namer.findAbstractMethod(env, type.tsym(), NameError.funNotFound, name, typeArray, type);
            if (symbol.kind < 256) {
                symbol = Namer.checkBestAbstractMethod(env, type.tsym(), symbol, typeArray, type);
            }
            return symbol;
        }
        Symbol symbol = type.tsym().locals().lookup(name);
        while (symbol.scope != null) {
            if (Namer.instantiatable(symbol.sym, typeArray, type)) {
                return Namer.findBestMethod(env, type, symbol, typeArray);
            }
            symbol = symbol.next();
        }
        return NameError.funNotFound;
    }

    static Symbol findPredefFun(Env env, Name name, Type[] typeArray) {
        Symbol symbol = Symbol.predefClass.locals().lookup(name);
        while (symbol.scope != null) {
            if (Namer.instantiatable(symbol.sym, typeArray, Symbol.predefClass.type)) {
                return Namer.findBestMethod(env, Symbol.predefClass.type, symbol, typeArray);
            }
            symbol = symbol.next();
        }
        return NameError.funNotFound;
    }

    static Symbol findImportedMethod(Env env, Scope scope, Name name, Type[] typeArray) {
        Symbol symbol = scope.lookup(name);
        while (symbol.scope != null) {
            if (Namer.instantiatable(symbol.sym, typeArray, symbol.sym.owner.type)) {
                return Namer.findBestMethod(env, env.enclClass.sym.type, symbol, typeArray);
            }
            symbol = symbol.next();
        }
        return NameError.funNotFound;
    }

    static Symbol findFun(Env env, Name name, Type[] typeArray) {
        Symbol symbol;
        Symbol symbol2 = NameError.funNotFound;
        Env env2 = env;
        while (true) {
            Env env3;
            Symbol symbol3 = ((ContextInfo)env2.info).scope.lookup(name);
            while (symbol3.scope != null) {
                if (Namer.instantiatable(symbol3.sym, typeArray, env.enclClass.sym.type)) {
                    return symbol3.sym;
                }
                symbol3 = symbol3.next();
            }
            symbol = Namer.findMethod(env2, env2.enclClass.sym.type, name, typeArray);
            if (symbol.kind < 256) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            if ((env3 = env2.outer) == null || env3.outer == null) break;
            symbol = Namer.findAny(env2.enclClass.sym, 8, name);
            if (symbol != null && Namer.accessible(env2, env2.enclClass.sym, symbol)) {
                return symbol2;
            }
            env2 = env3;
        }
        symbol = Namer.findImportedMethod(env, env.toplevel.namedImportScope, name, typeArray);
        if (symbol.kind < 256) {
            return symbol;
        }
        if (symbol.kind < symbol2.kind) {
            symbol2 = symbol;
        }
        symbol = Namer.findImportedMethod(env, env.toplevel.starImportScope, name, typeArray);
        if (symbol.kind < 256) {
            return symbol;
        }
        if (symbol.kind < symbol2.kind) {
            symbol2 = symbol;
        }
        symbol = Namer.findMethod(env, Symbol.predefClass.type, name, typeArray);
        if (symbol.kind < 256) {
            return symbol;
        }
        return symbol2;
    }

    public static Symbol findAny(TypeSymbol typeSymbol, int n, Name name) {
        Symbol symbol = typeSymbol.locals().lookup((Name)name).sym;
        while (symbol.scope != null) {
            if (symbol.sym.kind == n) {
                return symbol.sym;
            }
            symbol = symbol.next();
        }
        return null;
    }

    static Symbol loadClass(Env env, Name name) {
        try {
            ClassSymbol classSymbol = Symtab.reader.loadClass(name);
            if (Namer.accessible(env, classSymbol)) {
                return classSymbol;
            }
            return new AccessError(classSymbol);
        }
        catch (IOException iOException) {
            return new LoadError(iOException, 2, name);
        }
    }

    static Symbol loadPackage(Env env, Name name) {
        try {
            return Symtab.reader.loadPackage(name);
        }
        catch (IOException iOException) {
            return new LoadError(iOException, 1, name);
        }
    }

    static Symbol findImportedType(Env env, Scope scope, Name name) {
        Symbol symbol = scope.lookup(name);
        while (symbol.scope != null && symbol.sym.kind != 2) {
            symbol = symbol.next();
        }
        if (symbol.scope != null) {
            Symbol symbol2 = symbol.next();
            while (symbol2.scope != null && symbol2.sym.kind != 2) {
                symbol2 = symbol2.next();
            }
            if (symbol2.scope != null) {
                return new AmbiguityError(symbol.sym, symbol2.sym);
            }
            return Namer.loadClass(env, symbol.sym.fullName());
        }
        return NameError.typeNotFound;
    }

    static Symbol findMemberType(Env env, TypeSymbol typeSymbol, Name name) {
        NameError nameError = NameError.typeNotFound;
        Symbol symbol = typeSymbol.locals().lookup(name);
        while (symbol.scope != null) {
            if (symbol.sym.kind == 2) {
                if (Namer.accessible(env, typeSymbol, symbol.sym)) {
                    return symbol.sym;
                }
                if (258 < nameError.kind) {
                    nameError = new AccessError(symbol.sym);
                }
            }
            symbol = symbol.next();
        }
        return nameError;
    }

    static Symbol findType(Env env, Name name) {
        Symbol symbol;
        Symbol symbol2 = NameError.typeNotFound;
        if (((ContextInfo)env.info).scope != null) {
            Symbol symbol3 = ((ContextInfo)env.info).scope.lookup(name);
            while (symbol3.scope != null) {
                if (symbol3.sym.kind == 2) {
                    return symbol3.sym;
                }
                symbol3 = symbol3.next();
            }
            symbol = Namer.findMemberType(env, env.enclClass.sym, name);
            if (symbol.kind < 256) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            Env env2 = env.outer;
            while (env2.outer != null) {
                symbol3 = ((ContextInfo)env2.info).scope.lookup(name);
                while (symbol3.scope != null) {
                    if (symbol3.sym.kind == 2) {
                        return symbol3.sym;
                    }
                    symbol3 = symbol3.next();
                }
                symbol = Namer.findMemberType(env2, env2.enclClass.sym, name);
                if (symbol.kind < 256) {
                    return symbol;
                }
                if (symbol.kind < symbol2.kind) {
                    symbol2 = symbol;
                }
                env2 = env2.outer;
            }
        }
        symbol = Namer.findImportedType(env, env.toplevel.namedImportScope, name);
        if (symbol.kind < 256) {
            return symbol;
        }
        if (symbol.kind < symbol2.kind) {
            symbol2 = symbol;
        }
        symbol = Namer.findImportedType(env, env.toplevel.packge.locals(), name);
        if (symbol.kind < 256) {
            return symbol;
        }
        if (symbol.kind < symbol2.kind) {
            symbol2 = symbol;
        }
        symbol = Namer.findImportedType(env, env.toplevel.starImportScope, name);
        if (symbol.kind < 256) {
            return symbol;
        }
        if (symbol.kind < symbol2.kind) {
            symbol2 = symbol;
        }
        return symbol2;
    }

    static Symbol access(Symbol symbol, int n, Type type, Name name, Type[] typeArray) {
        if (symbol.kind >= 256) {
            ((NameError)symbol).report(n, type, name, typeArray);
            return Symbol.errSymbol;
        }
        return symbol;
    }

    static Symbol access(Symbol symbol, int n, Name name) {
        if (symbol.kind >= 256) {
            return Namer.access(symbol, n, Symbol.predefClass.type, name, null);
        }
        return symbol;
    }

    static void printscopes(Scope scope) {
        while (scope != null) {
            if (scope.owner != null) {
                System.out.print(String.valueOf(scope.owner).concat(String.valueOf(": ")));
            }
            Symbol symbol = scope.elems;
            while (symbol != null) {
                if ((symbol.sym.modifiers & 0x400) != 0) {
                    System.out.print("abstract ");
                }
                System.out.print(String.valueOf(String.valueOf(String.valueOf(symbol.sym).concat(String.valueOf("("))).concat(String.valueOf(symbol.name))).concat(String.valueOf("),\n")));
                symbol = symbol.sibling;
            }
            System.out.println();
            scope = scope.next;
        }
    }

    static void printscopes(Env env) {
        while (env.outer != null) {
            System.out.println("------------------------------");
            Namer.printscopes(((ContextInfo)env.info).scope);
            env = env.outer;
        }
    }

    static void printscopes2(Scope scope) {
        for (int i = 0; i < 128; ++i) {
            Symbol symbol = scope.hashtable[i];
            while (symbol.scope != null) {
                System.out.print(String.valueOf(symbol.sym).concat(String.valueOf(" ")));
                symbol = symbol.shadowed;
            }
            System.out.print(";");
        }
    }

    static Type[] protoArgs(Type type) {
        Type type2 = type.deref();
        switch (type2.pizza$v39$Type$$tag) {
            case 5: {
                Type.FunType funType = (Type.FunType)type2;
                Type type3 = funType.restype;
                Type[] typeArray = funType.argtypes;
                if (type3 == null) {
                    return typeArray;
                }
                return null;
            }
        }
        return null;
    }

    static Symbol resolveIdent(int n, Name name, Env env, int n2, Type type) {
        Symbol symbol;
        Symbol symbol2 = NameError.typeNotFound;
        if ((n2 & 4) != 0) {
            symbol2 = Namer.findVar(env, name);
        }
        if (symbol2.kind >= 256 && (n2 & 8) != 0) {
            symbol = Namer.findFun(env, name, Namer.protoArgs(type));
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        if (symbol2.kind >= 256 && (n2 & 2) != 0) {
            symbol = Namer.findType(env, name);
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        if (symbol2.kind >= 256 && (n2 & 1) != 0) {
            symbol = Namer.loadPackage(env, name);
            if (symbol.kind < 256) {
                symbol2 = symbol;
            } else if ((n2 & 2) != 0 && symbol2.kind == 261 && symbol.kind == 257) {
                symbol2 = new LoadError(((LoadError)symbol).fault, 3, name);
            }
        }
        if (symbol2.kind >= 256) {
            symbol2 = Namer.access(symbol2, n, env.enclClass.sym.type, name, Namer.protoArgs(type));
        }
        return symbol2;
    }

    static Symbol resolveSelf(int n, Name name, TypeSymbol typeSymbol, Env env) {
        Env env2 = env;
        while (env2 != null) {
            AST aST = env2.tree;
            switch (aST.pizza$v39$AST$$tag) {
                case 4: {
                    ClassSymbol classSymbol = ((AST.ClassDef)aST).sym;
                    if (typeSymbol != classSymbol) break;
                    return Namer.access(Namer.findVar(env2, name), n, name);
                }
            }
            env2 = env2.next;
        }
        Report.error(n, String.valueOf("not an enclosing class: ").concat(String.valueOf(Mangle.unmangle(typeSymbol.fullname))));
        return Symbol.errSymbol;
    }

    static Symbol resolveSelectFromPackage(TypeSymbol typeSymbol, Name name, Env env, int n) {
        Symbol symbol;
        Name name2 = Symbol.formFullName(name, typeSymbol);
        ClassSymbol classSymbol = (ClassSymbol)Symtab.reader.classes.pizza$util$Hashtable$get(name2);
        if (classSymbol == null) {
            symbol = (Symbol)Symtab.reader.packages.pizza$util$Hashtable$get(name2);
            if (symbol == null) {
                symbol = Namer.loadClass(env, name2);
                if (symbol.kind == 257 && (n & 1) != 0) {
                    Symbol symbol2 = symbol;
                    symbol = Namer.loadPackage(env, name2);
                    if (symbol.kind == 257) {
                        symbol = new LoadError(new IOException(String.valueOf(String.valueOf(((LoadError)symbol2).fault).concat(String.valueOf("; "))).concat(String.valueOf(((LoadError)symbol).fault))), 3, name2);
                    }
                }
            }
        } else {
            symbol = classSymbol.kind == 1 ? classSymbol : Namer.loadClass(env, name2);
        }
        return symbol;
    }

    static Symbol resolveSelectFromType(Type type, Name name, Env env, int n, Type type2) {
        Symbol symbol;
        Symbol symbol2 = NameError.typeNotFound;
        if ((n & 4) != 0) {
            symbol2 = Namer.findField(env, type.tsym(), name);
        }
        if (symbol2.kind >= 256 && (n & 8) != 0) {
            symbol = Namer.findMethod(env, type, name, Namer.protoArgs(type2));
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        if (symbol2.kind >= 256 && (n & 2) != 0) {
            symbol = Namer.findMemberType(env, type.tsym(), name);
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        return symbol2;
    }

    static Symbol resolveConstructor(int n, Type type, Env env, Type[] typeArray) {
        return Namer.access(Namer.findMethod(env, type, Basic.initS, typeArray), n, type, Basic.initS, typeArray);
    }

    static Symbol resolveOperator(int n, int n2, Env env, Type[] typeArray) {
        Name name = opname[n2];
        return Namer.access(Namer.findPredefFun(env, name, typeArray), n, null, name, typeArray);
    }

    static Symbol resolvePackage(int n, Name name, Env env) {
        return Namer.access(Namer.loadPackage(env, name), n, name);
    }

    static void notFound(int n, Name name, Name name2, Type[] typeArray) {
        Report.error(n, String.valueOf(String.valueOf(String.valueOf(String.valueOf("class not found or has wrong definition; cannot access ").concat(String.valueOf(name))).concat(String.valueOf(typeArray == null ? "" : String.valueOf(String.valueOf("(").concat(String.valueOf(Basic.toString((Object[])array.asObject(typeArray))))).concat(String.valueOf(")"))))).concat(String.valueOf(" in class "))).concat(String.valueOf(name2)));
    }

    static Symbol resolveMember(int n, Name name, Type type, Type[] typeArray, int n2) {
        Symbol symbol;
        Symbol symbol2 = symbol = typeArray == null ? Namer.findField(null, type.tsym(), name) : Namer.findMethod(null, type, name, typeArray);
        if (symbol.kind >= 256 || (symbol.modifiers & 1) == 0 || (symbol.modifiers & 8) != n2) {
            Namer.notFound(n, name, type.tsym().fullname, typeArray);
            throw new ResolveError();
        }
        return symbol;
    }

    static String kindName(int n) {
        switch (n) {
            case 1: {
                return "package";
            }
            case 2: {
                return "class";
            }
            case 4: {
                return "variable";
            }
            case 8: {
                return "function";
            }
            case 20: 
            case 28: {
                return "value";
            }
        }
        return String.valueOf(String.valueOf("identifier(").concat(String.valueOf(n))).concat(String.valueOf(")"));
    }

    static String kindNames(int n) {
        String[] stringArray = new String[4];
        int n2 = 0;
        if ((n & 4) != 0) {
            stringArray[n2++] = "variable";
        }
        if ((n & 8) != 0) {
            stringArray[n2++] = "function";
        }
        if ((n & 2) != 0) {
            stringArray[n2++] = "class";
        }
        if ((n & 1) != 0) {
            stringArray[n2++] = "package";
        }
        String string = "";
        for (int i = 0; i < n2 - 2; ++i) {
            string = String.valueOf(String.valueOf(string).concat(String.valueOf(stringArray[i]))).concat(String.valueOf(", "));
        }
        if (n2 >= 2) {
            string = String.valueOf(String.valueOf(string).concat(String.valueOf(stringArray[n2 - 2]))).concat(String.valueOf(" or "));
        }
        string = n2 >= 1 ? String.valueOf(string).concat(String.valueOf(stringArray[n2 - 1])) : "identifier";
        return string;
    }

    static boolean checkKind(int n, int n2, int n3) {
        if (n2 == 31 || (n2 & ~n3) == 0 || n3 == 8 && (n2 & 0xFFFFFFEB) == 0) {
            return true;
        }
        Report.error(n, String.valueOf(String.valueOf(String.valueOf(Namer.kindNames(n3)).concat(String.valueOf(" required, but "))).concat(String.valueOf(Namer.kindName(n2)))).concat(String.valueOf(" found")));
        return false;
    }

    static int firstMod(int n) {
        int n2;
        for (n2 = 0; n2 < 11 && (n & 1 << n2) == 0; ++n2) {
        }
        return n2;
    }

    static Name modName(int n) {
        switch (n) {
            case 0: {
                return Name.fromString("public");
            }
            case 1: {
                return Name.fromString("private");
            }
            case 2: {
                return Name.fromString("protected");
            }
            case 3: {
                return Name.fromString("static");
            }
            case 4: {
                return Name.fromString("final");
            }
            case 5: {
                return Name.fromString("synchronized");
            }
            case 6: {
                return Name.fromString("volatile");
            }
            case 7: {
                return Name.fromString("transient");
            }
            case 8: {
                return Name.fromString("native");
            }
            case 9: {
                return Name.fromString("interface");
            }
            case 10: {
                return Name.fromString("abstract");
            }
        }
        throw new InternalError(String.valueOf("modName ").concat(String.valueOf(n)));
    }

    static String modNames(int n) {
        String string = "";
        while ((n & 0xFFFF) != 0) {
            int n2 = Namer.firstMod(n);
            string = String.valueOf(String.valueOf(string).concat(String.valueOf(Namer.modName(n2)))).concat(String.valueOf(" "));
            n ^= 1 << n2;
        }
        return string;
    }

    static boolean checkDisjoint(int n, int n2, int n3, int n4) {
        if ((n2 & n3) != 0 && (n2 & n4) != 0) {
            Report.error(n, String.valueOf(String.valueOf(String.valueOf("illegal combination of modifiers: ").concat(String.valueOf(Namer.modName(Namer.firstMod(n2 & n3))))).concat(String.valueOf(" and "))).concat(String.valueOf(Namer.modName(Namer.firstMod(n2 & n4)))));
            return false;
        }
        return true;
    }

    static int checkMods(int n, int n2, int n3, boolean bl) {
        if ((n2 & 0xFFFF & ~n3) != 0) {
            Report.error(n, String.valueOf(String.valueOf("modifier ").concat(String.valueOf(Namer.modName(Namer.firstMod(n2 & 0xFFFF & ~n3))))).concat(String.valueOf(" not allowed here")));
        } else if (!Namer.checkDisjoint(n, n2, 1536, 304) || !bl && !Namer.checkDisjoint(n, n2, 1024, 8) || !Namer.checkDisjoint(n, n2, 1, 6) || !Namer.checkDisjoint(n, n2, 2, 5) || Namer.checkDisjoint(n, n2, 16, 64)) {
            // empty if block
        }
        return n2 & (n3 | 0xFFFF0000);
    }

    static int completeMods(int n, int n2, Env env, int n3, int n4) {
        if (Switches.experimental) {
            n4 &= 0xFFFFFFFE;
        }
        if ((env.enclClass.mods & 0x200) != 0) {
            int n5 = Namer.checkMods(n, n2, n4 | 1, false);
            return n5 | n4 | env.enclClass.mods & 1;
        }
        return Namer.checkMods(n, n2, n3, false);
    }

    static void checkStatic(int n, Symbol symbol) {
        if ((symbol.modifiers & 8) == 0 && symbol.owner != null && symbol.owner.kind == 2 && symbol.kind != 2) {
            Report.error(n, String.valueOf(String.valueOf("non-static ").concat(String.valueOf(symbol))).concat(String.valueOf(" cannot be referenced from a static context")));
        }
    }

    static boolean existsStatic(Symbol symbol, Env env) {
        if (((ContextInfo)env.info).isStatic) {
            return true;
        }
        if (env.outer != null) {
            while (env.outer.outer != null && !env.enclClass.sym.subclass(symbol)) {
                if ((env.enclClass.sym.modifiers & 8) != 0) {
                    return true;
                }
                env = env.outer;
            }
        }
        return false;
    }

    static boolean checkNonAbstract(int n, Symbol symbol) {
        if ((symbol.modifiers & 0x400) != 0) {
            Report.error(n, String.valueOf(String.valueOf("abstract ").concat(String.valueOf(symbol))).concat(String.valueOf(" cannot be accessed directly")));
            return false;
        }
        return true;
    }

    static void fixupScope(int n, TypeSymbol typeSymbol) {
        if (typeSymbol.locals() != null) {
            if (typeSymbol.locals().next == null && typeSymbol.supertype() != null) {
                typeSymbol.locals().next = typeSymbol.locals();
                Namer.fixupScope(n, typeSymbol.supertype().tsym());
                for (int i = 0; i < typeSymbol.interfaces().length; ++i) {
                    Namer.fixupScope(n, typeSymbol.interfaces()[i].tsym());
                }
                if (typeSymbol.owner.kind != 1) {
                    Namer.fixupScope(n, typeSymbol.owner.enclClass());
                }
                if (typeSymbol.locals().next == typeSymbol.locals()) {
                    typeSymbol.locals().baseOn(typeSymbol.supertype().tsym().locals());
                }
            } else if (typeSymbol.locals().next == typeSymbol.locals()) {
                Report.error(n, String.valueOf("cyclic inheritance involving ").concat(String.valueOf(typeSymbol)));
                typeSymbol.locals().baseOn(Symtab.objectType.tsym().locals());
                typeSymbol.setSupertype(Symtab.objectType);
                typeSymbol.setInterfaces(new Type[0]);
            }
        }
    }

    Namer() {
    }

    static {
        Namer.opname[2] = Name.fromString("+");
        Namer.opname[3] = Name.fromString("-");
        Namer.opname[4] = Name.fromString("!");
        Namer.opname[5] = Name.fromString("~");
        Namer.opname[6] = Name.fromString("++");
        Namer.opname[7] = Name.fromString("--");
        Namer.opname[8] = Name.fromString("++");
        Namer.opname[9] = Name.fromString("--");
        Namer.opname[10] = Name.fromString("||");
        Namer.opname[11] = Name.fromString("&&");
        Namer.opname[12] = Name.fromString("==");
        Namer.opname[13] = Name.fromString("!=");
        Namer.opname[14] = Name.fromString("<");
        Namer.opname[15] = Name.fromString(">");
        Namer.opname[16] = Name.fromString("<=");
        Namer.opname[17] = Name.fromString(">=");
        Namer.opname[18] = Name.fromString("|");
        Namer.opname[19] = Name.fromString("^");
        Namer.opname[20] = Name.fromString("&");
        Namer.opname[21] = Name.fromString("<<");
        Namer.opname[22] = Name.fromString(">>");
        Namer.opname[23] = Name.fromString(">>>");
        Namer.opname[24] = Name.fromString("+");
        Namer.opname[25] = Name.fromString("-");
        Namer.opname[26] = Name.fromString("*");
        Namer.opname[27] = Name.fromString("/");
        Namer.opname[28] = Name.fromString("%");
    }
}

