###--- >>> `ar' <<<----- Fit Autoregressive Models to Time Series

	## alias	 help(ar)
	## alias	 help(ar.burg)
	## alias	 help(ar.yw)
	## alias	 help(ar.ols)
	## alias	 help(ar.mle)
	## alias	 help(print.ar)
	## alias	 help(predict.ar)

##___ Examples ___:

data(lh)
ar(lh)
ar(lh, method="burg")
ar(lh, method="ols")

data(LakeHuron)
ar(LakeHuron)
ar(LakeHuron, method="burg")
ar(LakeHuron, method="ols")

data(sunspot)
sunspot.ar <- ar(sunspot.year)
sunspot.ar
ar(x = sunspot.year, method = "burg")
ar(x = sunspot.year, method = "ols")
##Don't run: ## next is slow and may have convergence problems,
##D ## as it cares about invertibility
##D ar(x = sunspot.year, method = "mle")

predict(sunspot.ar, n.ahead=25)

data(BJsales)
ar(ts.union(BJsales, BJsales.lead))

data(EuStockMarkets)
x <- diff(log(EuStockMarkets))
ar.ols(x, order.max=6)

## Keywords: 'ts'.


