###--- >>> `read.socket' <<<----- Read from or write to a socket

	## alias	 help(read.socket)
	## alias	 help(write.socket)

##___ Examples ___:

finger <- function(user, host = "localhost", port = 79, print = TRUE)
{
    if (!is.character(user))
        stop("user name must be a string")
    user <- paste(user,"\r\n")
    socket <- make.socket(host, port)
    on.exit(close.socket(socket))
    write.socket(socket, user)
    output <- character(0)
    repeat{
        ss <- read.socket(socket)
        if (ss == "") break
        output <- paste(output, ss)
    }
    close.socket(socket)
    if (print) cat(output)
    invisible(output)
}
##Don't run: finger("root")  ## only works if your site provides a finger daemon

## Keywords: 'misc'.


