###--- >>> `par' <<<----- Set or Query Graphical Parameters

	## alias	 help(par)
	## alias	 help(.Pars)
	## alias	 help(.Pars.readonly)

##___ Examples ___:

op <- par(mfrow = c(2, 2), # 2 x 2 pictures on one plot
          pty = "s")      # square plotting region, independent of device size

## At end of plotting, reset to previous settings:
par(op)

par("ylog")# FALSE
plot(1:12,log="y")
par("ylog")# TRUE

( nr.prof <-
  c(prof.pilots=16,lawyers=11,farmers=10,salesmen=9,physicians=9,
    mechanics=6,policemen=6,managers=6,engineers=5,teachers=4,
    housewives=3,students=3,armed.forces=1))
par(las=3)
barplot(rbind(nr.prof)) # R 0.63.2: shows alignment problem
par(las=0)# reset to default

ex <- function() {
   old.par <- par(no.readonly = TRUE)# all par settings which could be changed.
   on.exit(par(old.par))
   ## ...
   ## ... do lots of par(..) settings and plots
   ## ...
   invisible() #-- now,  par(old.par)  will be executed
}
ex()

## Keywords: 'iplot', 'dplot', 'environment'.


