###--- >>> `model.extract' <<<----- Extract components from a model frame

	## alias	 help(model.extract)
	## alias	 help(model.offset)
	## alias	 help(model.response)

##___ Examples ___:

data(esoph)
a <- model.frame(cbind(ncases,ncontrols) ~ agegp+tobgp+alcgp,data=esoph)
model.extract(a,"response")
all(model.extract(a,"response") == model.response(a))

a <- model.frame(ncases/(ncases+ncontrols) ~ agegp+tobgp+alcgp,
                 data = esoph, weights = ncases+ncontrols)
model.response(a)
model.extract(a,"weights")

a <- model.frame(cbind(ncases,ncontrols) ~ agegp,
                 something = tobgp, data = esoph)
names(a)
all(model.extract(a,"something")==esoph$tobgp) # TRUE

## Keywords: 'manip', 'programming', 'models'.


