###--- >>> `svd' <<<----- Singular Value Decomposition of a Matrix

	## alias	 help(svd)

##___ Examples ___:

hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, "+") }
str(X <- hilbert(9)[,1:6])
str(s <- svd(X))
Eps <- 10 * .Machine$double.eps

all(abs(diag(s$d) - t(s$u)%*% X %*% s$v) < Eps)# TRUE:  D = U' X V

X <- cbind(1,1:7)
str(s <- svd(X))
all(abs(diag(s$d) - t(s$u)%*% X %*% s$v) < Eps)# TRUE:  D = U' X V

## Keywords: 'algebra', 'array'.


