###--- >>> `rowsum' <<<----- Give row sums of a matrix, based on a grouping variable.

	## alias	 help(rowsum)

##___ Examples ___:

x <- matrix(runif(100), ncol=5)
group <- sample(1:8, 20, T)
xsum <- rowsum(x, group)

#same result another way, slower, and temp may be much larger than x
temp <- model.matrix( ~a -1, data.frame(a=as.factor(group)))
xsum2<- t(temp) %*% x

#same as last one, but really slow
xsum3 <- tapply(x, list(group[row(x)], col(x)), sum)


## Keywords: 'manip'.


