###--- >>> `persp' <<<----- Perspective Plots

	## alias	 help(persp)

##___ Examples ___:

# (1) The Obligatory Mathematical surface.
#     Rotated sinc function.

x <- seq(-10,10,length=50)
y <- x
f <- function(x,y)
{
        r <- sqrt(x^2+y^2)
        sin(r)/r
}
z <- outer(x,y,f)
z[is.na(z)] <- 1
persp(x, y, z, theta=30, phi=30, expand=0.5, col="lightblue")

# (2) Visualizing a simple DEM model

data(volcano)
z <- 2 * volcano        # Exaggerate the relief
x <- 10 * (1:nrow(z))   # 10 meter spacing (S to N)
y <- 10 * (1:ncol(z))   # 10 meter spacing (E to W)
persp(x, y, z, theta=120, phi=15, scale=FALSE)

# (3) Now something more complex
#     We border the surface, to make it more "slice like"
#     and color the top and sides of the surface differently.

zmin <- min(z)-20
z <- rbind(zmin, cbind(zmin, z, zmin), zmin)
x <- c(min(x)-1e-10, x, max(x)+1e-10)
y <- c(min(y)-1e-10, y, max(y)+1e-10)

fill <- matrix("green2", nr=nrow(z)-1, nc=ncol(z)-1)
fill[,1] <- "gray"
fill[,ncol(fill)] <- "gray"
fill[1,] <- "gray"
fill[nrow(fill),] <- "gray"

par(bg="lightblue")
persp(x, y, z, theta=120, phi=15, col=fill, scale=F)
title(main="Maunga Whau\nOne of 50 Volcanoes in the Auckland Region.",
font.main=4)


## Keywords: 'hplot', 'aplot'.


