###--- >>> `model.matrix' <<<----- Construct design matrices

	## alias	 help(model.matrix)
	## alias	 help(model.matrix.default)
	## alias	 help(model.matrix.lm)

##___ Examples ___:

data(trees)
ff <- log(Volume) ~ log(Height) + log(Girth)
str(m <- model.frame(ff, trees))
mat <- model.matrix(ff, m)

dd <- data.frame(a = gl(3,4), b = gl(4,1,12))# balanced 2-way
options("contrasts")
model.matrix(~a+b,dd)
model.matrix(~a+b,dd,contrasts=list(a="contr.sum"))
model.matrix(~a+b,dd,contrasts=list(a="contr.sum",b="contr.poly"))
m.orth <- model.matrix(~a+b,dd, contrasts=list(a="contr.helmert"))
crossprod(m.orth)# m.orth is  ALMOST  orthogonal

## Keywords: 'models'.


