###--- >>> `layout' <<<----- Specifying complex plot arrangements

	## alias	 help(layout)
	## alias	 help(layout.show)

##___ Examples ___:

 def.par <- par()# save default, for resetting...

 ## divide the device into two rows and two columns
 ## allocate figure 1 all of row 1
 ## allocate figure 2 the intersection of column 2 and row 2
 layout(matrix(c(1,1,0,2), 2, 2, byrow=T))
 ## show the regions that have been allocated to each plot
 layout.show(2)

 ## divide device into two rows and two columns
 ## allocate figure 1 and figure 2 as above
 ## respect relations between widths and heights
 nf <- layout(matrix(c(1,1,0,2), 2, 2, byrow=T), respect=T)
 layout.show(nf)

 ## create single figure which is 5cm square
 nf <- layout(matrix(1), widths=lcm(5), heights=lcm(5))
 layout.show(nf)

 ##-- Create a scatterplot with marginal histograms -----

 x <- rnorm(50)
 y <- rnorm(50)
 xhist <- hist(x, breaks=seq(-3,3,0.5), plot=F)
 yhist <- hist(y, breaks=seq(-3,3,0.5), plot=F)
 top <- max(c(xhist$counts, yhist$counts))
 xrange <- c(-3,3)
 yrange <- c(-3,3)
 nf <- layout(matrix(c(2,0,1,3),2,2,T), c(3,1), c(1,3), T)
 layout.show(nf)

 par(mar=c(3,3,1,1))
 plot(x, y, xlim=xrange, ylim=yrange, xlab="", ylab="")
 par(mar=c(0,3,1,1))
 barplot(xhist$counts, axes=F, ylim=c(0, top), space=0)
 par(mar=c(3,0,1,1))
 barplot(yhist$counts, axes=F, xlim=c(0, top), space=0, horiz=T)

 par(def.par)#- reset to default

## Keywords: 'iplot', 'dplot', 'environment'.


