###--- >>> `influence.measures' <<<----- Regression Diagnostics

	## alias	 help(influence.measures)
	## alias	 help(print.infl)
	## alias	 help(summary.infl)
	## alias	 help(hat)
	## alias	 help(rstudent)
	## alias	 help(dfbetas)
	## alias	 help(dffits)
	## alias	 help(covratio)
	## alias	 help(cooks.distance)

##___ Examples ___:

## Analysis of the life-cycle savings data
## given in Belsley, Kuh and Welsch.
data(savings)
lm.SR <- lm(sr ~ pop15 + pop75 + dpi + ddpi, data = savings)
summary(inflm.SR <- influence.measures(lm.SR))
inflm.SR
which(apply(inflm.SR$is.inf, 1, any)) # which observations `are' influential
dim(dfb <- dfbetas(lm.SR))            # the 1st columns of influence.measures
all(dfb == inflm.SR$infmat[, 1:5])
rstudent(lm.SR)
dffits(lm.SR)
covratio(lm.SR)

## Keywords: 'regression'.


