###--- >>> `fft' <<<----- Fast Discrete Fourier Transform

	## alias	 help(fft)
	## alias	 help(mvfft)

##___ Examples ___:

x <- 1:4
fft(x)
all(fft(fft(x), inverse = TRUE)/(x*length(x)) == 1+0i)
## In general, not exactly, but still:
x <- rnorm(100)
all(Mod(fft(fft(x), inverse=TRUE)/(x*length(x)) - 1) < 1e-12)

plot(fft(c(9:0,0:13, numeric(301))), type = "l")
periodogram <- function(x) { # simple periodogram
  n <- length(x)
  Mod(fft(unclass(x)))[1:(n%/%2 + 1)]^2 / (2*pi*n)
}
data(sunspots)
plot(10*log10(periodogram(sunspots)), type = "b", col = "blue")

## Keywords: 'math', 'dplot'.


