###--- >>> `density' <<<----- Kernel Density Estimation

	## alias	 help(density)
	## alias	 help(print.density)
	## alias	 help(plot.density)

##___ Examples ___:

# The Old Faithful geyser data
data(faithful)
d <- density(faithful$eruptions, bw=0.15)
d
plot(d)

plot(d, type="n")
polygon(d, col="wheat")

## Missing values:
x <- xx <- faithful$eruptions
x[i.out <- sample(length(x), 10)] <- NA
doR <- density(x, bw=0.15, na.rm = TRUE)
doN <- density(x, bw=0.15, na.rm = FALSE)
lines(doR, col="blue")
lines(doN, col="red")
points(xx[i.out], rep(.01,10))

## Keywords: 'dplot', 'distribution', 'smooth'.


