###--- >>> `backsolve' <<<----- Solve an Upper or Lower Triangular System

	## alias	 help(backsolve)
	## alias	 help(forwardsolve)

##___ Examples ___:

## upper triangular matrix 'r':
r <- rbind(c(1,2,3),
           c(0,1,1),
           c(0,0,2))
( y <- backsolve(r, x <- c(8,4,2)) ) # -1 3 1
r %*% y # == x = (8,4,2)
c( y2 <- backsolve(r, x, transpose = TRUE)) # 8 -12 -5
all(t(r) %*% y2 == x)# exactly on Linux (Pentium)
all(y  == backsolve(t(r), x, upper = FALSE, transpose = TRUE))
all(y2 == backsolve(t(r), x, upper = FALSE,  transpose = FALSE))

## Keywords: 'algebra', 'array'.


