
#import <swarmgraph/JavaControl.h>
#import <activity/ActionCache.h>


@implementation JavaControl;

+ new {
  self = [JavaControl alloc];
  return [self init: [JavaClass new: "JavaJCtlPanel"]];
}

- init: (id)ctlClass {
  // construct a java object and set up your object and java class ptrs
  jobject ctlObj = [ctlClass construct];
  [super init: ctlClass : ctlObj];

  // set up some local state
  _getState = 0;
  _setState = 0;
  _waitRun = 0;
  return self;
}


void sendAction(JNIEnv *env, jobject obj, 
		jlong actionCache, jobject actName,
		jlong actType, jlong arg)
{
  char * cmd = (*env)->GetStringUTFChars(env, actName, NULL);
  fprintf(stderr, "whooo whee... sendAction called with ");
  fprintf(stderr, "%s %x\n", cmd, (unsigned)actType);

  // make a new action and drop it in to be executed
  [(id)actionCache sendActionOfType: (id <Symbol>))actType toExecute: cmd];
  (*env)->ReleaseStringUTFChars(env, actName, cmd);
}

JNINativeMethod methods[] = {
  {"sendAction", "(JLjava/lang/String;JJ)V", (void *)sendAction}
};

- setActionCache:  (id) actionCache {
  jmethodID setActionCache;

  // first, find the java action cache class and add a native
  // method so that when it sends actions, they go back to objective
  // c, where they will get added to the action cache
  jclass jactionid = [javaEnv findClass: "JavaJAction"];
  JNIEnv * env = [javaEnv getEnv];
  if ((*env)->RegisterNatives(env, jactionid, methods, 1) < 0)
    fprintf(stderr, "ERROR: couldn't register sendAction\n");


  // give the objc pointer to the java object
  setActionCache = [classid findMethod: "setActionCache" 
			    signature: "(I)V"];
  [self callVoidMethod: setActionCache : actionCache];

  // load up some actions that it can invoke
  [self addAction: "Run" : Control];
  [self addAction: "Stop" : Control];
  [self addAction: "Step" : Control];
  [self addAction: "Next" : Control];
  [self addAction: "Quit" : Control];
  [self addAction: "Probe" : Probing];

  return self;
}

- addAction:  (char *) actName : (id)actId {
  // give the objc pointer to the java object
  if (_addAction == 0)
    _addAction = [classid findMethod: "addAction" 
			  signature: "(Ljava/lang/String;I)V"];
  [self callVoidMethod: _addAction S: (char *)actName I: (int)actId];
  return self;
}


- (int) getState {
  jint state;

  if (_getState == 0) {
    _getState = [classid findMethod: "getState" signature: "()I"];
  }

  state = [self callIntMethod: _getState];
  return state;
}

- (void) setState: (int)state {
  if (_setState == 0)
    _setState = [classid findMethod: "setState" signature: "(I)V"];

  [self callVoidMethod: _setState : state];
}

- (void) waitRun {
  if (_waitRun == 0)
    _waitRun = [classid findMethod: "waitRUN" signature: "()V"];

  [self callVoidMethod: _waitRun];
}

@end
