//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            UniformDouble.h
Description:     Uniform distribution returning double values
Library:         random
Original Author: Nelson Minar
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/


#import <random/RandomDefs.h>
#import <random/ProbabilityDistribution.h>

@interface UniformDouble: ProbabilityDistribution //<UniformDouble>

{

// Parameters:

   double doubleMin;
   double doubleMax;
   double doubleRange;

// Working variables:


}

// Methods that conform to the UniformDouble protocol:

+create: aZone setGenerator: generator
	setDoubleMin: (double) minValue setMax: (double) maxValue;

-(void) setDoubleMin: (double) minValue setMax: (double) maxValue;

-(double) getDoubleMin;
-(double) getDoubleMax;

-(double) getDoubleWithMin: (double) minValue withMax: (double) maxValue;

// Methods that conform to the DoubleDistribution protocol:

-(double) getDoubleSample;

// Methods that override superclass methods:

// -(void) getState: (void *) state;
// -(void) setState: (void *) state;

// -initState;
// -resetState;

@end
