//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            SCGgen.h
Description:     Subtractive Congruential Generator
Library:         random
Original Author: Nelson Minar
Date:            1996-09-09
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/

// This generator returns successive pseudo-random UNSIGNED INTEGERS
// in the closed interval [0, 10^9-1]:

// SCG is a member of the Lagged Fibonacci class of generators.

#define SCGLONGLAG  55
#define SCGSHORTLAG 24
#define SCGMODULUS  1000000000

#import <random/RandomNumberGenerator.h>


@interface SCG: RandomNumberGenerator

{

// Parameters:

   unsigned s;		// short lag
   unsigned r;		// long lag (=size of state vector)

// Data objects (state variables):

   unsigned index;		// pointer to current value
   unsigned state[SCGLONGLAG];	// vector of lagged values (state vector)

}

// The following RandomNumberGenerator methods are overridden:

// -initState;
// -resetState;

// -(void) getState: (void *) stateBuf;
// -(void) setState: (void *) stateBuf;

// -(unsigned) getUnsignedSample;

@end
