// Template application. Copyright (C) 1997 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <collections.h>
#import <activity.h>
#import <simtools.h>
#import <swarmobject/SwarmObject.h>
#import "ActionHolder.h"

// Type Symbols
extern id <Symbol> Control, Probing, Spatial;
// Error symbols
extern id <Symbol> InvalidActionType, ActionTypeNotImplemented;

@interface ActionCache : SwarmObject {
  id <List> actionCache;
  id <Schedule> destinationSchedule;
  id ctrlPanel;
}

// Create Phase methods
-setScheduleContext: (id) context;
-createEnd;

// Use phase methods
-insertAction: (id) actionHolder;
-deliverActions;
-verifyActions;

@end
