/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    long gregorianCutover;
    private static final int[] mins = new int[]{0, 1, 0, 0, 0, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -43200000, 0};
    private static final int[] maxs = new int[]{1, 5000000, 11, 54, 6, 31, 366, 7, 6, 1, 12, 23, 59, 59, 999, 43200000, 3600000};
    private static final int[] leastMaximums = new int[]{1, 5000000, 11, 53, 6, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
    private static final long serialVersionUID = -8125100834729963327L;

    private /* synthetic */ void finit$() {
        this.gregorianCutover = -12219292800000L;
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone zone) {
        this(zone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone zone, Locale locale) {
        super(zone, locale);
        this.finit$();
        this.setDefaultTime();
    }

    public GregorianCalendar(int year, int month, int date) {
        this();
        this.set(year, month, date, 0, 0, 0);
    }

    public GregorianCalendar(int year, int month, int date, int hour, int minute) {
        this();
        this.set(year, month, date, hour, minute, 0);
    }

    public GregorianCalendar(int year, int month, int date, int hour, int minute, int second) {
        this();
        this.set(year, month, date, hour, minute, second);
    }

    private final void setDefaultTime() {
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public int getMinimum(int calfield) {
        return mins[calfield];
    }

    public int getGreatestMinimum(int calfield) {
        return mins[calfield];
    }

    public int getMaximum(int calfield) {
        return maxs[calfield];
    }

    public int getLeastMaximum(int calfield) {
        return leastMaximums[calfield];
    }

    protected native void computeFields();

    protected native void computeTime();

    public void add(int fld, int amount) {
        if (fld >= 15) {
            throw new IllegalArgumentException("bad field to add");
        }
        this.fields[fld] = this.fields[fld] + amount;
        this.adjust(fld);
    }

    public void roll(int fld, boolean up) {
        if (fld >= 15) {
            throw new IllegalArgumentException("bad field to roll");
        }
        int old = this.fields[fld];
        this.fields[fld] = up ? (old == this.getMaximum(fld) ? this.getMinimum(fld) : old + 1) : (old == this.getMinimum(fld) ? this.getMaximum(fld) : old - 1);
    }

    private void adjust(int fld) {
        int value = this.fields[fld];
        int radix = maxs[fld] + 1;
        switch (fld) {
            case 2: 
            case 13: 
            case 14: {
                if (value >= radix) {
                    int next = value / radix;
                    this.fields[fld] = value - radix * next;
                    this.fields[fld - 1] = this.fields[fld - 1] + next;
                    this.adjust(fld - 1);
                    break;
                }
                if (value >= 0) break;
                int next = (value - radix - 1) / radix;
                this.fields[fld] = value - radix * next;
                this.fields[fld - 1] = this.fields[fld - 1] + next;
                this.adjust(fld - 1);
            }
        }
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 100 != 0 || year % 400 == 0) {
            return true;
        }
        GregorianCalendar date = new GregorianCalendar(year, 1, 28);
        return this.gregorianCutover < date.getTimeInMillis();
    }

    public boolean after(Object cal) {
        return cal instanceof Calendar && this.getTimeInMillis() > ((Calendar)cal).getTimeInMillis();
    }

    public boolean before(Object cal) {
        return cal instanceof Calendar && this.getTimeInMillis() < ((Calendar)cal).getTimeInMillis();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar other = (GregorianCalendar)obj;
        int i = 17;
        while (--i >= 0) {
            boolean set = this.isSet[i];
            if (set == other.isSet[i] && (!set || this.fields[i] == other.fields[i])) continue;
            return false;
        }
        return this.areFieldsSet == other.areFieldsSet && this.isTimeSet == other.isTimeSet && (!this.isTimeSet || this.time == other.time) && this.getFirstDayOfWeek() == other.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == other.getMinimalDaysInFirstWeek() && this.isLenient() == other.isLenient() && this.getTimeZone().equals(other.getTimeZone());
    }

    public int hashCode() {
        int hashcode = 0;
        int i = 17;
        while (--i >= 0) {
            if (!this.isSet[i]) continue;
            hashcode += 37 * this.fields[i];
        }
        if (this.isTimeSet) {
            hashcode += (int)((long)89 * this.time);
        }
        return hashcode;
    }
}

