/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    public abstract Iterator iterator();

    public abstract int size();

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        Iterator itr = c.iterator();
        int size = c.size();
        boolean modified = false;
        for (int pos = 0; pos < size; ++pos) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    public void clear() {
        Iterator itr = this.iterator();
        int size = this.size();
        for (int pos = 0; pos < size; ++pos) {
            itr.next();
            itr.remove();
        }
    }

    public boolean contains(Object o) {
        Iterator itr = this.iterator();
        int size = this.size();
        for (int pos = 0; pos < size; ++pos) {
            if (!(o == null ? itr.next() == null : o.equals(itr.next()))) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator itr = c.iterator();
        int size = c.size();
        for (int pos = 0; pos < size; ++pos) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(Object o) {
        Iterator itr = this.iterator();
        int size = this.size();
        for (int pos = 0; pos < size; ++pos) {
            if (!(o == null ? itr.next() == null : o.equals(itr.next()))) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        Iterator itr = this.iterator();
        int size = this.size();
        boolean modified = false;
        for (int pos = 0; pos < size; ++pos) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        Iterator itr = this.iterator();
        int size = this.size();
        boolean modified = false;
        for (int pos = 0; pos < size; ++pos) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public Object[] toArray() {
        Iterator itr = this.iterator();
        Object[] a = new Object[this.size()];
        for (int pos = 0; pos < a.length; ++pos) {
            a[pos] = itr.next();
        }
        return a;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator itr = this.iterator();
        for (int pos = 0; pos < size; ++pos) {
            a[pos] = itr.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public String toString() {
        Iterator itr = this.iterator();
        int size = this.size();
        StringBuffer r = new StringBuffer("[");
        for (int pos = 0; pos < size; ++pos) {
            r.append(itr.next());
            if (pos >= size - 1) continue;
            r.append(", ");
        }
        r.append("]");
        return r.toString();
    }
}

