/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    public static final double MIN_VALUE = 4.9E-324;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final Class TYPE;
    private double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public static native double parseDouble(String var0) throws NumberFormatException;

    public Double(double v) {
        this.value = v;
    }

    public Double(String s) {
        this.value = Double.valueOf(s);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Double)) {
            return false;
        }
        Double d = (Double)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(d);
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)v ^ (int)(v >>> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    static native String toString(double var0, boolean var2);

    public static String toString(double v) {
        return Double.toString(v, false);
    }

    public static Double valueOf(String s) {
        return new Double(Double.parseDouble(s));
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public static boolean isNaN(double v) {
        long bits = Double.doubleToLongBits(v);
        long e = bits & 0x7FF0000000000000L;
        long f = bits & 0xFFFFFFFFFFFFFL;
        return e == 0x7FF0000000000000L && f != 0L;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double v) {
        long bits = Double.doubleToLongBits(v);
        long f = bits & Long.MAX_VALUE;
        return f == 0x7FF0000000000000L;
    }

    public static native long doubleToLongBits(double var0);

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    public int compareTo(Double d) {
        double v = d.value;
        if (Double.isNaN(this.value)) {
            if (Double.isNaN(v)) {
                return 1;
            }
            return 0;
        }
        if (Double.isNaN(v)) {
            return -1;
        }
        if (this.value == 0.0 && v == 0.0) {
            return 1;
        }
        if (this.value == 0.0 && v == 0.0) {
            return -1;
        }
        if (this.value == v) {
            return 0;
        }
        if (this.value > v) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Double)o);
    }
}

