/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.lang.ClassHelper;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class EventSetDescriptor
extends FeatureDescriptor {
    private Method addListenerMethod;
    private Method removeListenerMethod;
    private Class listenerType;
    private MethodDescriptor[] listenerMethodDescriptors;
    private Method[] listenerMethods;
    private boolean unicast;
    private boolean inDefaultEventSet;

    static /* synthetic */ Class class$(String type$) {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.inDefaultEventSet = true;
    }

    public EventSetDescriptor(Class eventSourceClass, String eventSetName, Class listenerType, String listenerMethodName) throws IntrospectionException {
        this.finit$();
        this.setName(eventSetName);
        if (!EventSetDescriptor.class$("java.util.EventListener").isAssignableFrom(listenerType)) {
            throw new IntrospectionException("Listener type is not an EventListener.");
        }
        String[] names = new String[]{listenerMethodName};
        try {
            eventSetName = Character.toUpperCase(eventSetName.charAt(0)) + eventSetName.substring(1);
        }
        catch (StringIndexOutOfBoundsException e) {
            eventSetName = "";
        }
        this.findMethods(eventSourceClass, listenerType, names, "add" + eventSetName + "Listener", "remove" + eventSetName + "Listener", eventSetName + "Event");
        this.listenerType = listenerType;
        this.checkAddListenerUnicast();
        if (this.removeListenerMethod.getExceptionTypes().length > 0) {
            throw new IntrospectionException("Listener remove method throws exceptions.");
        }
    }

    public EventSetDescriptor(Class eventSourceClass, String eventSetName, Class listenerType, String[] listenerMethodNames, String addListenerMethodName, String removeListenerMethodName) throws IntrospectionException {
        this.finit$();
        this.setName(eventSetName);
        if (!EventSetDescriptor.class$("java.util.EventListener").isAssignableFrom(listenerType)) {
            throw new IntrospectionException("Listener type is not an EventListener.");
        }
        this.findMethods(eventSourceClass, listenerType, listenerMethodNames, addListenerMethodName, removeListenerMethodName, null);
        this.listenerType = listenerType;
        this.checkAddListenerUnicast();
        if (this.removeListenerMethod.getExceptionTypes().length > 0) {
            throw new IntrospectionException("Listener remove method throws exceptions.");
        }
    }

    public EventSetDescriptor(String eventSetName, Class listenerType, Method[] listenerMethods, Method addListenerMethod, Method removeListenerMethod) throws IntrospectionException {
        this.finit$();
        this.setName(eventSetName);
        if (!EventSetDescriptor.class$("java.util.EventListener").isAssignableFrom(listenerType)) {
            throw new IntrospectionException("Listener type is not an EventListener.");
        }
        this.listenerMethods = listenerMethods;
        this.addListenerMethod = addListenerMethod;
        this.removeListenerMethod = removeListenerMethod;
        this.listenerType = listenerType;
        this.checkMethods();
        this.checkAddListenerUnicast();
        if (this.removeListenerMethod.getExceptionTypes().length > 0) {
            throw new IntrospectionException("Listener remove method throws exceptions.");
        }
    }

    public EventSetDescriptor(String eventSetName, Class listenerType, MethodDescriptor[] listenerMethodDescriptors, Method addListenerMethod, Method removeListenerMethod) throws IntrospectionException {
        this.finit$();
        this.setName(eventSetName);
        if (!EventSetDescriptor.class$("java.util.EventListener").isAssignableFrom(listenerType)) {
            throw new IntrospectionException("Listener type is not an EventListener.");
        }
        this.listenerMethodDescriptors = listenerMethodDescriptors;
        this.listenerMethods = new Method[listenerMethodDescriptors.length];
        for (int i = 0; i < this.listenerMethodDescriptors.length; ++i) {
            this.listenerMethods[i] = this.listenerMethodDescriptors[i].getMethod();
        }
        this.addListenerMethod = addListenerMethod;
        this.removeListenerMethod = removeListenerMethod;
        this.listenerType = listenerType;
        this.checkMethods();
        this.checkAddListenerUnicast();
        if (this.removeListenerMethod.getExceptionTypes().length > 0) {
            throw new IntrospectionException("Listener remove method throws exceptions.");
        }
    }

    public Class getListenerType() {
        return this.listenerType;
    }

    public Method[] getListenerMethods() {
        return this.listenerMethods;
    }

    public MethodDescriptor[] getListenerMethodDescriptors() {
        if (this.listenerMethodDescriptors == null) {
            this.listenerMethodDescriptors = new MethodDescriptor[this.listenerMethods.length];
            for (int i = 0; i < this.listenerMethods.length; ++i) {
                this.listenerMethodDescriptors[i] = new MethodDescriptor(this.listenerMethods[i]);
            }
        }
        return this.listenerMethodDescriptors;
    }

    public Method getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public Method getRemoveListenerMethod() {
        return this.removeListenerMethod;
    }

    public void setUnicast(boolean unicast) {
        this.unicast = unicast;
    }

    public boolean isUnicast() {
        return this.unicast;
    }

    public void setInDefaultEventSet(boolean inDefaultEventSet) {
        this.inDefaultEventSet = inDefaultEventSet;
    }

    public boolean isInDefaultEventSet() {
        return this.inDefaultEventSet;
    }

    private void checkAddListenerUnicast() throws IntrospectionException {
        Class[] addListenerExceptions = this.addListenerMethod.getExceptionTypes();
        if (addListenerExceptions.length > 1) {
            throw new IntrospectionException("Listener add method throws too many exceptions.");
        }
        if (addListenerExceptions.length == 1 && !EventSetDescriptor.class$("java.util.TooManyListenersException").isAssignableFrom(addListenerExceptions[0])) {
            throw new IntrospectionException("Listener add method throws too many exceptions.");
        }
    }

    private void checkMethods() throws IntrospectionException {
        if (!this.addListenerMethod.getDeclaringClass().isAssignableFrom(this.removeListenerMethod.getDeclaringClass()) && !this.removeListenerMethod.getDeclaringClass().isAssignableFrom(this.addListenerMethod.getDeclaringClass())) {
            throw new IntrospectionException("add and remove listener methods do not come from the same class.  This is bad.");
        }
        if (!(this.addListenerMethod.getReturnType().equals(Void.TYPE) && this.addListenerMethod.getParameterTypes().length == 1 && this.listenerType.equals(this.addListenerMethod.getParameterTypes()[0]) && Modifier.isPublic(this.addListenerMethod.getModifiers()))) {
            throw new IntrospectionException("Add Listener Method invalid.");
        }
        if (!(this.removeListenerMethod.getReturnType().equals(Void.TYPE) && this.removeListenerMethod.getParameterTypes().length == 1 && this.listenerType.equals(this.removeListenerMethod.getParameterTypes()[0]) && this.removeListenerMethod.getExceptionTypes().length <= 0 && Modifier.isPublic(this.removeListenerMethod.getModifiers()))) {
            throw new IntrospectionException("Remove Listener Method invalid.");
        }
        for (int i = 0; i < this.listenerMethods.length; ++i) {
            if (!this.listenerMethods[i].getReturnType().equals(Void.TYPE) || Modifier.isPrivate(this.listenerMethods[i].getModifiers())) {
                throw new IntrospectionException("Event Method " + this.listenerMethods[i].getName() + " non-void or private.");
            }
            if (this.listenerMethods[i].getDeclaringClass().isAssignableFrom(this.listenerType)) continue;
            throw new IntrospectionException("Event Method " + this.listenerMethods[i].getName() + " not from class " + this.listenerType.getName());
        }
    }

    private void findMethods(Class eventSourceClass, Class listenerType, String[] listenerMethodNames, String addListenerMethodName, String removeListenerMethodName, String absurdEventClassCheckName) throws IntrospectionException {
        int i;
        Method[] methods;
        Class[] listenerArgList = new Class[]{listenerType};
        try {
            this.addListenerMethod = eventSourceClass.getMethod(addListenerMethodName, listenerArgList);
        }
        catch (SecurityException E) {
            throw new IntrospectionException("SecurityException trying to access method " + addListenerMethodName + ".");
        }
        catch (NoSuchMethodException E) {
            throw new IntrospectionException("Could not find method " + addListenerMethodName + ".");
        }
        if (this.addListenerMethod == null || !this.addListenerMethod.getReturnType().equals(Void.TYPE)) {
            throw new IntrospectionException("Add listener method does not exist, is not public, or is not void.");
        }
        try {
            this.removeListenerMethod = eventSourceClass.getMethod(removeListenerMethodName, listenerArgList);
        }
        catch (SecurityException E) {
            throw new IntrospectionException("SecurityException trying to access method " + removeListenerMethodName + ".");
        }
        catch (NoSuchMethodException E) {
            throw new IntrospectionException("Could not find method " + removeListenerMethodName + ".");
        }
        if (this.removeListenerMethod == null || !this.removeListenerMethod.getReturnType().equals(Void.TYPE)) {
            throw new IntrospectionException("Remove listener method does not exist, is not public, or is not void.");
        }
        try {
            methods = ClassHelper.getAllMethods(listenerType);
        }
        catch (SecurityException E) {
            throw new IntrospectionException("Security: You cannot access fields in this class.");
        }
        Vector chosenMethods = new Vector();
        boolean[] listenerMethodFound = new boolean[listenerMethodNames.length];
        for (i = 0; i < methods.length; ++i) {
            Method currentMethod;
            Class retval;
            if (Modifier.isPrivate(methods[i].getModifiers()) || !(retval = (currentMethod = methods[i]).getReturnType()).equals(Void.TYPE)) continue;
            for (int j = 0; j < listenerMethodNames.length; ++j) {
                if (!currentMethod.getName().equals(listenerMethodNames[j]) || absurdEventClassCheckName != null && (currentMethod.getParameterTypes().length != 1 || !currentMethod.getParameterTypes()[0].getName().equals(absurdEventClassCheckName) && !currentMethod.getParameterTypes()[0].getName().endsWith("." + absurdEventClassCheckName))) continue;
                chosenMethods.addElement(currentMethod);
                listenerMethodFound[j] = true;
            }
        }
        for (i = 0; i < listenerMethodFound.length; ++i) {
            if (listenerMethodFound[i]) continue;
            throw new IntrospectionException("Could not find event method " + listenerMethodNames[i]);
        }
        this.listenerMethods = new Method[chosenMethods.size()];
        for (i = 0; i < chosenMethods.size(); ++i) {
            this.listenerMethods[i] = (Method)chosenMethods.elementAt(i);
        }
    }
}

