/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout
implements LayoutManager,
Serializable {
    private int hgap;
    private int vgap;
    private int rows;
    private int cols;

    public void addLayoutComponent(String name, Component comp) {
    }

    public int getColumns() {
        return this.cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    public GridLayout() {
        this(1, 0, 0, 0);
    }

    public GridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public GridLayout(int rows, int cols, int hgap, int vgap) {
        if (rows < 0) {
            throw new IllegalArgumentException("number of rows cannot be negative");
        }
        if (cols < 0) {
            throw new IllegalArgumentException("number of columns cannot be negative");
        }
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("both rows and columns cannot be 0");
        }
        if (hgap < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        if (vgap < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void layoutContainer(Container parent) {
        int num = parent.getComponentCount();
        Component[] comps = parent.component;
        int real_rows = this.rows;
        int real_cols = this.cols;
        if (real_rows == 0) {
            real_rows = (num + real_cols - 1) / real_cols;
        } else {
            real_cols = (num + real_rows - 1) / real_rows;
        }
        Dimension d = parent.getSize();
        Insets ins = parent.getInsets();
        int tw = d.width - ins.left - ins.right;
        int th = d.height - ins.top - ins.bottom;
        int w = (tw - (real_rows - 1) * this.hgap) / real_rows;
        int h = (th - (real_cols - 1) * this.vgap) / real_cols;
        int x = ins.left;
        int y = ins.top;
        int i = 0;
        int recount = 0;
        while (i < num) {
            comps[i].setBounds(x, y, tw, th);
            ++i;
            if (++recount == real_cols) {
                recount = 0;
                y += this.vgap + th;
                x = ins.left;
                continue;
            }
            x += this.hgap + tw;
        }
    }

    public Dimension minimumLayoutSize(Container cont) {
        return this.getSize(cont, true);
    }

    public Dimension preferredLayoutSize(Container cont) {
        return this.getSize(cont, false);
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void setColumns(int newCols) {
        if (this.cols < 0) {
            throw new IllegalArgumentException("number of columns cannot be negative");
        }
        if (newCols == 0 && this.rows == 0) {
            throw new IllegalArgumentException("number of rows is already 0");
        }
        this.cols = newCols;
    }

    public void setHgap(int hgap) {
        if (hgap < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        this.hgap = hgap;
    }

    public void setRows(int newRows) {
        if (this.rows < 0) {
            throw new IllegalArgumentException("number of rows cannot be negative");
        }
        if (newRows == 0 && this.cols == 0) {
            throw new IllegalArgumentException("number of columns is already 0");
        }
        this.rows = newRows;
    }

    public void setVgap(int vgap) {
        if (vgap < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.vgap = vgap;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }

    private Dimension getSize(Container parent, boolean is_min) {
        int w = 0;
        int h = 0;
        int num = parent.getComponentCount();
        Component[] comps = parent.component;
        for (int i = 0; i < num; ++i) {
            Dimension d = is_min ? comps[i].getMinimumSize() : comps[i].getPreferredSize();
            w = Math.max(d.width, w);
            h = Math.max(d.height, h);
        }
        int real_rows = this.rows;
        int real_cols = this.cols;
        if (real_rows == 0) {
            real_rows = (num + real_cols - 1) / real_cols;
        } else {
            real_cols = (num + real_rows - 1) / real_rows;
        }
        return new Dimension(real_rows * (w + this.hgap) - this.hgap, real_cols * (h + this.vgap) - this.vgap);
    }
}

