/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable {
    String label;
    boolean state;
    ItemListener listeners;

    public CheckboxMenuItem() {
        this(null, false);
    }

    public CheckboxMenuItem(String label) {
        this(label, false);
    }

    public CheckboxMenuItem(String label, boolean state) {
        this.label = label;
        this.state = state;
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, listener);
    }

    public void addNotify() {
        if (this.peer != null) {
            this.peer = Toolkit.getDefaultToolkit().createCheckboxMenuItem(this);
        }
    }

    public Object[] getSelectedObjects() {
        Object[] r = this.state ? new Object[]{this.label} : new Object[]{};
        return r;
    }

    public boolean getState() {
        return this.state;
    }

    public String paramString() {
        return "[" + this.getClass().getName() + "state=" + this.state + "," + "label=" + this.label + "]";
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.listeners != null) {
            this.listeners.itemStateChanged(event);
        }
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, listener);
    }

    public void setState(boolean state) {
        this.state = state;
        if (this.peer != null) {
            CheckboxMenuItemPeer cp = (CheckboxMenuItemPeer)this.peer;
            cp.setState(state);
        }
    }
}

