/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class SHA1PRNG
implements Serializable {
    MessageDigest digest;
    byte[] seed;
    byte[] data;
    int seedpos;
    int datapos;

    public SHA1PRNG() {
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            System.out.println("Failed to find SHA Message Digest: " + nsae);
            nsae.printStackTrace();
        }
        this.seed = new byte[20];
        this.seedpos = 0;
        this.data = new byte[40];
        this.datapos = 0;
        new Random().nextBytes(this.seed);
        byte[] digestdata = this.digest.digest(this.data);
        System.arraycopy(digestdata, 0, this.data, 0, 20);
    }

    public void engineSetSeed(byte[] seed) {
        for (int i = 0; i < seed.length; ++i) {
            this.seed[this.seedpos++ % 20] = this.seed[this.seedpos++ % 20] ^ seed[i];
        }
        this.seedpos %= 20;
    }

    public void engineNextBytes(byte[] bytes) {
        if (bytes.length < 20 - this.datapos) {
            System.arraycopy(bytes, 0, this.data, this.datapos, bytes.length);
            this.datapos += bytes.length;
            return;
        }
        int blen = bytes.length;
        int bpos = 0;
        while (bpos < blen) {
            int i = 20 - this.datapos;
            System.arraycopy(bytes, bpos, this.data, this.datapos, i);
            bpos += i;
            this.datapos += i;
            if (this.datapos < 20) continue;
            System.arraycopy(this.seed, 0, this.data, 20, 20);
            byte[] digestdata = this.digest.digest(this.data);
            System.arraycopy(digestdata, 0, this.data, 0, 20);
            this.datapos = 0;
        }
    }

    public byte[] engineGenerateSeed(int numBytes) {
        byte[] tmp = new byte[numBytes];
        this.engineNextBytes(tmp);
        return tmp;
    }
}

