/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.convert;

import gnu.gcj.convert.IOConverter;
import gnu.gcj.convert.Output_8859_1;
import gnu.gcj.convert.Output_iconv;
import java.io.UnsupportedEncodingException;

public abstract class UnicodeToBytes
extends IOConverter {
    public byte[] buf;
    public int count;
    static Class defaultEncodingClass;

    static synchronized void getDefaultEncodingClass() {
        if (defaultEncodingClass == null) {
            String encoding = IOConverter.canonicalize(System.getProperty("file.encoding"));
            String className = "gnu.gcj.convert.Output_" + encoding;
            try {
                defaultEncodingClass = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                throw new NoClassDefFoundError("missing default encoding " + encoding + " (class " + className + " not found)");
            }
        }
    }

    public abstract String getName();

    public static UnicodeToBytes getDefaultEncoder() {
        try {
            if (defaultEncodingClass == null) {
                UnicodeToBytes.getDefaultEncodingClass();
            }
            return (UnicodeToBytes)defaultEncodingClass.newInstance();
        }
        catch (Throwable ex) {
            try {
                return new Output_iconv(System.getProperty("file.encoding"));
            }
            catch (Throwable ex2) {
                return new Output_8859_1();
            }
        }
    }

    public static UnicodeToBytes getEncoder(String encoding) throws UnsupportedEncodingException {
        String className = "gnu.gcj.convert.Output_" + IOConverter.canonicalize(encoding);
        try {
            Class encodingClass = Class.forName(className);
            return (UnicodeToBytes)encodingClass.newInstance();
        }
        catch (Throwable ex) {
            try {
                return new Output_iconv(encoding);
            }
            catch (Throwable _) {
                throw new UnsupportedEncodingException(encoding + " (" + ex + ')');
            }
        }
    }

    public final void setOutput(byte[] buffer, int count) {
        this.buf = buffer;
        this.count = count;
    }

    public abstract int write(char[] var1, int var2, int var3);

    public int write(String str, int inpos, int inlength, char[] work) {
        if (work == null) {
            work = new char[inlength];
        }
        int srcEnd = inpos + (inlength > work.length ? work.length : inlength);
        str.getChars(inpos, srcEnd, work, 0);
        return this.write(work, 0, srcEnd - inpos);
    }
}

