/*
 * Decompiled with CFR 0.152.
 */
package at.dms.util;

import java.util.Stack;

public final class SimpleStringBuffer {
    private static final int BUFFER_SIZE = 100;
    private static final Stack stack = new Stack();
    private char[] buf = new char[100];
    private int pos;

    public void reset() {
        this.pos = 0;
    }

    public String toString() {
        return String.valueOf(this.buf, 0, this.pos);
    }

    public void append(String string) {
        int n = string.length();
        try {
            string.getChars(0, n, this.buf, this.pos);
            this.pos += n;
        }
        catch (Exception exception) {
            this.grow(n + 16);
            this.append(string);
        }
    }

    public void append(char c) {
        try {
            this.buf[this.pos] = c;
            ++this.pos;
        }
        catch (Exception exception) {
            this.grow(16);
            this.buf[this.pos++] = c;
        }
    }

    private void grow(int n) {
        char[] cArray = new char[this.buf.length + n];
        System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
        this.buf = cArray;
    }

    public static SimpleStringBuffer request() {
        if (stack.empty()) {
            return new SimpleStringBuffer();
        }
        SimpleStringBuffer simpleStringBuffer = (SimpleStringBuffer)stack.pop();
        simpleStringBuffer.reset();
        return simpleStringBuffer;
    }

    public static void release(SimpleStringBuffer simpleStringBuffer) {
        if (simpleStringBuffer != null) {
            stack.push(simpleStringBuffer);
        }
    }
}

