/*
 * Decompiled with CFR 0.152.
 */
package at.dms.optimize;

import at.dms.classfile.AbstractInstructionAccessor;
import at.dms.classfile.Constants;
import at.dms.classfile.Instruction;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.classfile.PushLiteralInstruction;
import at.dms.optimize.InstructionHandle;
import at.dms.util.InconsistencyException;

public class Patterns
implements Constants {
    public static boolean optimize(InstructionHandle instructionHandle) {
        int n = instructionHandle.getOpcode();
        switch (n) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                return Patterns.optimizeJump(instructionHandle, n);
            }
            case 0: 
            case 1: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return Patterns.optimizeNoArgInstruction(instructionHandle, n);
            }
            case 182: 
            case 183: 
            case 184: {
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                return Patterns.optimizeFieldRefInstruction(instructionHandle, n);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 169: {
                return Patterns.optimizeLocalVarInstruction(instructionHandle, n);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return Patterns.optimizePushLiteralInstruction(instructionHandle, n);
            }
        }
        instructionHandle.set();
        return false;
    }

    public static boolean optimizeJump(InstructionHandle instructionHandle, int n) {
        AbstractInstructionAccessor abstractInstructionAccessor;
        JumpInstruction jumpInstruction = (JumpInstruction)instructionHandle.getInstruction();
        if (jumpInstruction.getTarget() == instructionHandle.getNext()) {
            switch (n) {
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    instructionHandle.replaceBy(new NoArgInstruction(88));
                    return true;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    instructionHandle.replaceBy(new NoArgInstruction(87));
                    return true;
                }
                case 167: {
                    instructionHandle.destroy();
                    return true;
                }
            }
        }
        if (instructionHandle.getTarget().getOpcode() == 167) {
            if (instructionHandle.getTarget() == instructionHandle.getTarget().getTarget()) {
                instructionHandle.set();
                return false;
            }
            instructionHandle.getTarget().removeAccessor(jumpInstruction);
            instructionHandle.setTarget(instructionHandle.getTarget().getTarget());
            instructionHandle.getTarget().addAccessor(jumpInstruction);
            instructionHandle.set();
            return true;
        }
        if (instructionHandle.getOpcode() == 167) {
            switch (instructionHandle.getTarget().getOpcode()) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    instructionHandle.replaceBy(new Instruction[]{new JumpInstruction(instructionHandle.getTarget().getOpcode(), instructionHandle.getTarget().getJump().getTarget()), new JumpInstruction(167, instructionHandle.getTarget().getNext())});
                    instructionHandle.set();
                    return true;
                }
            }
        }
        if (instructionHandle.getNext() != null && instructionHandle.getNext().isJump() && instructionHandle.getTarget() == instructionHandle.getNext().getNext() && ((InstructionHandle)(abstractInstructionAccessor = instructionHandle.getNext())).getJump().getOpcode() == 167 && !((InstructionHandle)abstractInstructionAccessor).isTarget()) {
            switch (n) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 198: 
                case 199: {
                    instructionHandle.replaceBy(new JumpInstruction(Patterns.getReverseOpcode(n), ((InstructionHandle)abstractInstructionAccessor).getJump().getTarget()));
                    ((InstructionHandle)abstractInstructionAccessor).destroy();
                    return true;
                }
            }
        }
        if (n == 167 && instructionHandle.getTarget().getInstruction() instanceof NoArgInstruction && !((NoArgInstruction)(abstractInstructionAccessor = (NoArgInstruction)instructionHandle.getTarget().getInstruction())).canComplete()) {
            instructionHandle.replaceBy(new NoArgInstruction(((Instruction)abstractInstructionAccessor).getOpcode()));
            return true;
        }
        instructionHandle.set();
        return false;
    }

    public static boolean optimizeNoArgInstruction(InstructionHandle instructionHandle, int n) {
        if (n == 0) {
            if (instructionHandle.remove()) {
                return true;
            }
            instructionHandle.set();
            return false;
        }
        instructionHandle.set();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean optimizePushLiteralInstruction(InstructionHandle instructionHandle, int n) {
        block30: {
            block31: {
                InstructionHandle instructionHandle2;
                block32: {
                    PushLiteralInstruction pushLiteralInstruction = (PushLiteralInstruction)instructionHandle.getInstruction();
                    if (!instructionHandle.getNext().isJump()) break block31;
                    instructionHandle2 = instructionHandle.getNext();
                    if (n != 3) break block32;
                    switch (instructionHandle2.getOpcode()) {
                        case 159: {
                            instructionHandle.replaceBy(new Instruction[]{new JumpInstruction(153, instructionHandle2.getTarget()), new JumpInstruction(167, instructionHandle2.getNext())});
                            return true;
                        }
                        case 160: {
                            instructionHandle.replaceBy(new Instruction[]{new JumpInstruction(154, instructionHandle2.getTarget()), new JumpInstruction(167, instructionHandle2.getNext())});
                            return true;
                        }
                        case 161: {
                            instructionHandle.replaceBy(new Instruction[]{new JumpInstruction(155, instructionHandle2.getTarget()), new JumpInstruction(167, instructionHandle2.getNext())});
                            return true;
                        }
                        case 163: {
                            instructionHandle.replaceBy(new Instruction[]{new JumpInstruction(157, instructionHandle2.getTarget()), new JumpInstruction(167, instructionHandle2.getNext())});
                            return true;
                        }
                        case 162: {
                            instructionHandle.replaceBy(new Instruction[]{new JumpInstruction(156, instructionHandle2.getTarget()), new JumpInstruction(167, instructionHandle2.getNext())});
                            return true;
                        }
                        case 164: {
                            instructionHandle.replaceBy(new Instruction[]{new JumpInstruction(158, instructionHandle2.getTarget()), new JumpInstruction(167, instructionHandle2.getNext())});
                            return true;
                        }
                        case 153: {
                            instructionHandle.replaceBy(new JumpInstruction(167, instructionHandle2.getTarget()));
                            return true;
                        }
                        case 154: {
                            instructionHandle.replaceBy(new JumpInstruction(167, instructionHandle2.getNext()));
                            return true;
                        }
                    }
                    break block30;
                }
                if (((PushLiteralInstruction)instructionHandle.getInstruction()).getLiteral() instanceof Integer) {
                    if (instructionHandle2.getOpcode() == 154) {
                        instructionHandle.replaceBy(new JumpInstruction(167, instructionHandle2.getTarget()));
                        return true;
                    }
                    if (instructionHandle2.getOpcode() == 153) {
                        instructionHandle.replaceBy(new JumpInstruction(167, instructionHandle2.getNext()));
                        return true;
                    }
                    break block30;
                } else if (n == 1 && !instructionHandle.getNext().isTarget()) {
                    if (instructionHandle2.getOpcode() == 165) {
                        instructionHandle.replaceBy(new JumpInstruction(198, instructionHandle2.getTarget()));
                        instructionHandle2.destroy();
                        return true;
                    }
                    if (instructionHandle2.getOpcode() == 166) {
                        instructionHandle.replaceBy(new JumpInstruction(199, instructionHandle2.getTarget()));
                        instructionHandle2.destroy();
                        return true;
                    }
                    if (instructionHandle2.getOpcode() == 198) {
                        instructionHandle.replaceBy(new JumpInstruction(167, instructionHandle2.getTarget()));
                        instructionHandle2.destroy();
                        return true;
                    }
                    if (instructionHandle2.getOpcode() == 199) {
                        instructionHandle.destroy();
                        instructionHandle2.destroy();
                        return true;
                    }
                    break block30;
                } else if (n != 18) {
                    // empty if block
                }
                break block30;
            }
            if (!instructionHandle.getNext().isTarget() && instructionHandle.getNext().getOpcode() == 87) {
                InstructionHandle instructionHandle3 = instructionHandle.getNext();
                instructionHandle.destroy();
                instructionHandle3.destroy();
                return true;
            }
            if (!instructionHandle.getNext().isTarget() && instructionHandle.getNext().getOpcode() == 88) {
                InstructionHandle instructionHandle4 = instructionHandle.getNext();
                switch (n) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        instructionHandle.replaceBy(new NoArgInstruction(87));
                        instructionHandle4.destroy();
                        return true;
                    }
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 20: {
                        instructionHandle.destroy();
                        instructionHandle4.destroy();
                        return true;
                    }
                }
                throw new InconsistencyException("invalid opcode: " + n);
            }
            if (n == 2 && !instructionHandle.getNext().isTarget() && instructionHandle.getNext().getOpcode() == 130 && !instructionHandle.getNext().getNext().isTarget()) {
                if (instructionHandle.getNext().getNext().getOpcode() == 153) {
                    instructionHandle.replaceBy(new JumpInstruction(154, instructionHandle.getNext().getNext().getTarget()));
                    instructionHandle.getNext().getNext().destroy();
                    instructionHandle.getNext().destroy();
                    return true;
                }
                if (instructionHandle.getNext().getNext().getOpcode() == 154) {
                    instructionHandle.replaceBy(new JumpInstruction(153, instructionHandle.getNext().getNext().getTarget()));
                    instructionHandle.getNext().getNext().destroy();
                    instructionHandle.getNext().destroy();
                    return true;
                }
            }
        }
        instructionHandle.set();
        return false;
    }

    private static int getReverseOpcode(int n) {
        switch (n) {
            case 165: {
                return 166;
            }
            case 166: {
                return 165;
            }
            case 159: {
                return 160;
            }
            case 160: {
                return 159;
            }
            case 161: {
                return 162;
            }
            case 164: {
                return 163;
            }
            case 163: {
                return 164;
            }
            case 162: {
                return 161;
            }
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 155: {
                return 156;
            }
            case 157: {
                return 158;
            }
            case 158: {
                return 157;
            }
            case 156: {
                return 155;
            }
            case 198: {
                return 199;
            }
            case 199: {
                return 198;
            }
        }
        throw new InconsistencyException("OPCODE NOT ALLOWED:" + n);
    }

    private static boolean optimize5(InstructionHandle instructionHandle, int n) {
        if (instructionHandle.getNext() == null || instructionHandle.getNext().getNext() == null || instructionHandle.getNext().getNext().getNext() == null || instructionHandle.getNext().getNext().getNext().getNext() == null) {
            return false;
        }
        switch (n) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                boolean bl;
                boolean bl2;
                InstructionHandle instructionHandle2 = instructionHandle.getNext();
                if (instructionHandle2.getOpcode() == 3) {
                    bl2 = true;
                } else {
                    if (instructionHandle2.getOpcode() != 4) break;
                    bl2 = false;
                }
                InstructionHandle instructionHandle3 = instructionHandle2 = instructionHandle2.getNext();
                if (instructionHandle2.getOpcode() != 167 || (instructionHandle2 = instructionHandle2.getNext()).getOpcode() != 3 && instructionHandle2.getOpcode() != 4 || instructionHandle2.getOpcode() == 3 && bl2 || instructionHandle2.getOpcode() == 4 && !bl2) break;
                instructionHandle2 = instructionHandle2.getNext();
                if (instructionHandle3.getTarget() != instructionHandle2) break;
                if (instructionHandle2.getOpcode() == 153) {
                    bl = true;
                } else {
                    if (instructionHandle2.getOpcode() != 154) break;
                    bl = false;
                }
                boolean bl3 = bl2 ? bl : (bl = !bl);
                if (instructionHandle3.isTarget()) {
                    System.err.println("BEEP");
                    break;
                }
                if (bl) {
                    instructionHandle.replaceBy(new JumpInstruction(Patterns.getReverseOpcode(n), instructionHandle2.getTarget()));
                } else {
                    instructionHandle.replaceBy(new JumpInstruction(n, instructionHandle2.getTarget()));
                }
                instructionHandle.getNext().getNext().getNext().getNext().destroy();
                instructionHandle.getNext().getNext().getNext().destroy();
                instructionHandle.getNext().getNext().destroy();
                instructionHandle.getNext().destroy();
                return true;
            }
        }
        return false;
    }

    private static boolean optimizeLocalVarInstruction(InstructionHandle instructionHandle, int n) {
        if (instructionHandle.getNext() == null) {
            instructionHandle.set();
            return false;
        }
        if (instructionHandle.getNext().getOpcode() == 87 && !instructionHandle.getNext().isTarget()) {
            InstructionHandle instructionHandle2 = instructionHandle.getNext();
            instructionHandle.destroy();
            instructionHandle2.destroy();
            return true;
        }
        if (instructionHandle.getNext().getOpcode() == 88 && !instructionHandle.getNext().isTarget()) {
            if (instructionHandle.getInstruction().getStack() == 2) {
                instructionHandle.getNext().destroy();
                instructionHandle.destroy();
                return true;
            }
            instructionHandle.getNext().destroy();
            instructionHandle.replaceBy(new NoArgInstruction(87));
            return true;
        }
        if (instructionHandle.getNext().getInstruction() instanceof LocalVarInstruction && !instructionHandle.getNext().isTarget() && instructionHandle.getLocal().isLoad() && instructionHandle.getNext().getLocal().isStore() && ((LocalVarInstruction)instructionHandle.getInstruction()).getIndex() == ((LocalVarInstruction)instructionHandle.getNext().getInstruction()).getIndex() && !instructionHandle.getNext().isTarget()) {
            instructionHandle.destroy();
            instructionHandle.getNext().destroy();
            return true;
        }
        instructionHandle.set();
        return false;
    }

    private static boolean optimizeFieldRefInstruction(InstructionHandle instructionHandle, int n) {
        if (instructionHandle.getInstruction().getStack() == 0) {
            if (instructionHandle.getNext().getOpcode() == 87 || instructionHandle.getNext().getOpcode() == 88) {
                instructionHandle.destroy();
                return true;
            }
        } else if (instructionHandle.getInstruction().getStack() == 1) {
            if (instructionHandle.getNext().getOpcode() == 87) {
                instructionHandle.replaceBy(new JumpInstruction(167, instructionHandle.getNext().getNext()));
                return true;
            }
            if (instructionHandle.getNext().getOpcode() == 88) {
                instructionHandle.replaceBy(new Instruction[]{new NoArgInstruction(87), new JumpInstruction(167, instructionHandle.getNext().getNext())});
                return true;
            }
        } else if (instructionHandle.getInstruction().getStack() == 2 && instructionHandle.getNext().getOpcode() == 88) {
            instructionHandle.replaceBy(new JumpInstruction(167, instructionHandle.getNext().getNext()));
            return true;
        }
        instructionHandle.set();
        return false;
    }
}

