/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CLineError;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JStatement;
import at.dms.kjc.JVariableDefinition;
import at.dms.kjc.KjcVisitor;

public class JVariableDeclarationStatement
extends JStatement {
    private JVariableDefinition[] vars;

    public JVariableDefinition[] getVars() {
        return this.vars;
    }

    public void setIsInFor() {
        int n = 0;
        while (n < this.vars.length) {
            this.vars[n].setIsLoopVariable();
            ++n;
        }
    }

    public void unsetIsInFor() {
        int n = 0;
        while (n < this.vars.length) {
            this.vars[n].unsetIsLoopVariable();
            ++n;
        }
    }

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        int n = 0;
        while (n < this.vars.length) {
            try {
                cBodyContext.getBlockContext().addVariable(this.vars[n]);
                this.vars[n].analyse(cBodyContext);
                if (this.vars[n].hasInitializer()) {
                    cBodyContext.setVariableInfo(this.vars[n].getIndex(), 3);
                }
            }
            catch (UnpositionedError unpositionedError) {
                throw new CLineError(this.getTokenReference(), unpositionedError.getFormattedMessage());
            }
            ++n;
        }
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitVariableDeclarationStatement(this, this.vars);
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        int n = 0;
        while (n < this.vars.length) {
            if (this.vars[n].getValue() != null) {
                this.vars[n].getValue().genCode(codeSequence, false);
                this.vars[n].genStore(codeSequence);
            }
            ++n;
        }
    }

    public JVariableDeclarationStatement(TokenReference tokenReference, JVariableDefinition[] jVariableDefinitionArray, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.vars = jVariableDefinitionArray;
    }

    public JVariableDeclarationStatement(TokenReference tokenReference, JVariableDefinition jVariableDefinition, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.vars = new JVariableDefinition[]{jVariableDefinition};
    }
}

