/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.JavadocComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClass;
import at.dms.kjc.CClassContext;
import at.dms.kjc.CClassType;
import at.dms.kjc.CContext;
import at.dms.kjc.CMethod;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.CSourceField;
import at.dms.kjc.CTopLevel;
import at.dms.kjc.JConstructorDeclaration;
import at.dms.kjc.JFieldDeclaration;
import at.dms.kjc.JInitializerDeclaration;
import at.dms.kjc.JMemberDeclaration;
import at.dms.kjc.JMethodDeclaration;
import at.dms.kjc.JPhylum;
import at.dms.kjc.JVariableDefinition;
import at.dms.kjc.KjcMessages;
import java.util.Hashtable;

public abstract class JTypeDeclaration
extends JMemberDeclaration {
    protected int modifiers;
    protected String ident;
    protected JPhylum[] body;
    protected JFieldDeclaration[] fields;
    protected JMethodDeclaration[] methods;
    protected JTypeDeclaration[] inners;
    protected CClassType[] interfaces;
    private JFieldDeclaration outerThis;
    private JConstructorDeclaration defaultConstructor;
    protected JInitializerDeclaration statInit;
    protected JInitializerDeclaration instanceInit;
    protected CSourceClass sourceClass;
    private boolean uniqueSourceClass = true;

    public void generateInterface(CClass cClass, String string) {
        this.sourceClass = new CSourceClass(cClass, this.getTokenReference(), this.modifiers, this.ident, string + this.ident, this.isDeprecated());
        this.setInterface(this.sourceClass);
        CClassType[] cClassTypeArray = new CClassType[this.inners.length];
        int n = 0;
        while (n < this.inners.length) {
            this.inners[n].generateInterface(this.sourceClass, this.sourceClass.getQualifiedName() + "$");
            cClassTypeArray[n] = this.inners[n].getCClass().getType();
            ++n;
        }
        this.sourceClass.setInnerClasses(cClassTypeArray);
        this.uniqueSourceClass = CTopLevel.addSourceClass(this.sourceClass);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
        if (this.sourceClass != null) {
            this.sourceClass.setModifiers(n);
        }
    }

    public boolean isNested() {
        return this.getCClass().isNested();
    }

    public JFieldDeclaration[] getFields() {
        return this.fields;
    }

    public JConstructorDeclaration getDefaultConstructor() {
        return this.defaultConstructor;
    }

    public void setDefaultConstructor(JConstructorDeclaration jConstructorDeclaration) {
        this.defaultConstructor = jConstructorDeclaration;
    }

    public void setIdent(String string) {
        this.ident = string;
    }

    public abstract void checkInterface(CContext var1) throws PositionedError;

    protected void checkInterface(CContext cContext, CClassType cClassType) throws PositionedError {
        int n;
        CClassContext cClassContext = new CClassContext(cContext, this.sourceClass, this);
        if (!this.uniqueSourceClass) {
            cContext.reportTrouble(new PositionedError(this.getTokenReference(), KjcMessages.DUPLICATE_TYPE_NAME, (Object)this.sourceClass.getQualifiedName()));
        }
        if (!this.isNested() && this.sourceClass.isPublic() && !this.getTokenReference().getName().startsWith(this.ident + ".")) {
            cContext.reportTrouble(new PositionedError(this.getTokenReference(), KjcMessages.CLASS_NAME_FILENAME, this.ident, this.getTokenReference().getName()));
        }
        int n2 = 0;
        while (n2 < this.interfaces.length) {
            try {
                this.interfaces[n2].checkType(cClassContext);
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
            CClass cClass = this.interfaces[n2].getCClass();
            this.check(cContext, cClass.isInterface(), KjcMessages.SUPERINTERFACE_WRONG_TYPE, this.interfaces[n2].getQualifiedName());
            this.check(cContext, cClass.isAccessible(this.sourceClass), KjcMessages.SUPERINTERFACE_NOT_ACCESSIBLE, this.interfaces[n2].getQualifiedName());
            ++n2;
        }
        n2 = this.getCClass().hasOuterThis() ? 1 : 0;
        Hashtable<String, CSourceField> hashtable = new Hashtable<String, CSourceField>(this.fields.length + n2 + 1);
        int n3 = this.fields.length - 1;
        while (n3 >= 0) {
            CSourceField cSourceField = this.fields[n3].checkInterface(cClassContext);
            cSourceField.setPosition(n3);
            this.check(cContext, hashtable.put(cSourceField.getIdent(), cSourceField) == null, KjcMessages.FIELD_RENAME, cSourceField.getIdent());
            --n3;
        }
        if (n2 > 0) {
            CSourceField cSourceField = this.outerThis.checkInterface(cClassContext);
            cSourceField.setPosition(hashtable.size());
            this.check(cContext, hashtable.put("this$0", cSourceField) == null, KjcMessages.FIELD_RENAME, "this$0");
        }
        int n4 = 0;
        if (this.defaultConstructor != null) {
            ++n4;
        }
        if (this.statInit != null && !this.statInit.isDummy()) {
            ++n4;
        }
        if (this.instanceInit != null && !this.instanceInit.isDummy()) {
            ++n4;
        }
        CMethod[] cMethodArray = new CMethod[this.methods.length + n4];
        int n5 = 0;
        while (n5 < this.methods.length) {
            cMethodArray[n5] = this.methods[n5].checkInterface(cClassContext);
            n = 0;
            while (n < n5) {
                this.check(cContext, !cMethodArray[n5].equals(cMethodArray[n]), KjcMessages.METHOD_REDEFINE, cMethodArray[n5]);
                ++n;
            }
            ++n5;
        }
        n5 = this.methods.length;
        if (this.defaultConstructor != null) {
            cMethodArray[n5] = this.defaultConstructor.checkInterface(cClassContext);
            ++n5;
        }
        if (this.statInit != null) {
            if (!this.statInit.isDummy()) {
                cMethodArray[n5] = this.statInit.checkInterface(cClassContext);
                ++n5;
            } else {
                this.statInit.checkInterface(cClassContext);
            }
        }
        if (this.instanceInit != null) {
            if (!this.instanceInit.isDummy()) {
                cMethodArray[n5] = this.instanceInit.checkInterface(cClassContext);
                ++n5;
            } else {
                this.instanceInit.checkInterface(cClassContext);
            }
        }
        n = this.inners.length - 1;
        while (n >= 0) {
            this.inners[n].checkInterface(cClassContext);
            --n;
        }
        this.sourceClass.close(this.interfaces, cClassType, hashtable, cMethodArray);
    }

    public void checkInitializers(CContext cContext) throws PositionedError {
        int n = 0;
        while (n < this.interfaces.length) {
            int n2 = 0;
            while (n2 < n) {
                this.check(cContext, !this.interfaces[n].equals(this.interfaces[n2]), KjcMessages.INTERFACES_DUPLICATE, this.ident, this.interfaces[n]);
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.interfaces.length) {
            CClass cClass = this.sourceClass.getSuperClass();
            if (cClass != null && cClass.descendsFrom(this.interfaces[n].getCClass())) {
                cContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.INTERFACE_IMPLEMENTED_BY_SUPERCLASS, this.interfaces[n], cClass.getIdent()));
            }
            int n3 = 0;
            while (n3 < this.interfaces.length) {
                if (n3 != n && this.interfaces[n3].getCClass().descendsFrom(this.interfaces[n].getCClass())) {
                    cContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.INTERFACE_IMPLEMENTED_BY_SUPERCLASS, this.interfaces[n], this.interfaces[n3]));
                }
                ++n3;
            }
            ++n;
        }
    }

    public void addOuterThis() {
        if (this.outerThis == null) {
            this.sourceClass.setHasOuterThis(true);
            this.outerThis = new JFieldDeclaration(this.getTokenReference(), new JVariableDefinition(this.getTokenReference(), 18, this.getOwner().getCClass().getType(), "this$0", null), null, null);
            ((CSourceClass)this.getCClass()).addField(new CSourceField(this.getCClass(), 18, "this$0", this.getOwner().getCClass().getType(), false));
        }
    }

    public void checkTypeBody(CContext cContext) throws PositionedError {
        cContext.addSourceClass(this.sourceClass);
    }

    public CClass getOwner() {
        return this.getCClass().getOwner();
    }

    public JTypeDeclaration(TokenReference tokenReference, int n, String string, CClassType[] cClassTypeArray, JFieldDeclaration[] jFieldDeclarationArray, JMethodDeclaration[] jMethodDeclarationArray, JTypeDeclaration[] jTypeDeclarationArray, JPhylum[] jPhylumArray, JavadocComment javadocComment, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javadocComment, javaStyleCommentArray);
        this.modifiers = n;
        this.ident = string.intern();
        this.interfaces = cClassTypeArray;
        this.fields = jFieldDeclarationArray;
        this.methods = jMethodDeclarationArray;
        this.inners = jTypeDeclarationArray;
        this.body = jPhylumArray;
    }
}

