/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLocalVariable;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JReturnStatement
extends JStatement {
    protected JExpression expr;

    public CType getType() {
        return this.expr != null ? this.expr.getType() : CStdType.Void;
    }

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        CType cType = cBodyContext.getMethodContext().getCMethod().getReturnType();
        if (this.expr != null) {
            this.check(cBodyContext, cType != CStdType.Void, KjcMessages.RETURN_NONEMPTY_VOID);
            CExpressionContext cExpressionContext = new CExpressionContext(cBodyContext);
            this.expr = this.expr.analyse(cExpressionContext);
            this.check(cBodyContext, this.expr.isAssignableTo(cType), KjcMessages.RETURN_BADTYPE, this.expr.getType(), cType);
            this.expr = this.expr.convertType(cType, cExpressionContext);
        } else {
            this.check(cBodyContext, cType == CStdType.Void, KjcMessages.RETURN_EMPTY_NONVOID);
        }
        cBodyContext.setReachable(false);
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitReturnStatement(this, this.expr);
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        if (this.expr != null) {
            this.expr.genCode(codeSequence, false);
            codeSequence.plantReturn(this);
            codeSequence.plantNoArgInstruction(this.expr.getType().getReturnOpcode());
        } else {
            codeSequence.plantReturn(this);
            codeSequence.plantNoArgInstruction(177);
        }
    }

    public void load(CodeSequence codeSequence, JLocalVariable jLocalVariable) {
        codeSequence.plantLocalVar(this.expr.getType().getLoadOpcode(), jLocalVariable);
    }

    public void store(CodeSequence codeSequence, JLocalVariable jLocalVariable) {
        codeSequence.plantLocalVar(this.expr.getType().getStoreOpcode(), jLocalVariable);
    }

    public JReturnStatement(TokenReference tokenReference, JExpression jExpression, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.expr = jExpression;
    }
}

