/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JMultExpression
extends JBinaryArithmeticExpression {
    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        try {
            this.type = JMultExpression.computeType(this.left.getType(), this.right.getType());
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.left = this.left.convertType(this.type, cExpressionContext);
        this.right = this.right.convertType(this.type, cExpressionContext);
        if (this.left.isConstant() && this.right.isConstant()) {
            return this.constantFolding();
        }
        return this;
    }

    public static CType computeType(CType cType, CType cType2) throws UnpositionedError {
        if (cType.isNumeric() && cType2.isNumeric()) {
            return CNumericType.binaryPromote(cType, cType2);
        }
        throw new UnpositionedError(KjcMessages.MULT_BADTYPE, cType, cType2);
    }

    public int compute(int n, int n2) {
        return n * n2;
    }

    public long compute(long l, long l2) {
        return l * l2;
    }

    public float compute(float f, float f2) {
        return f * f2;
    }

    public double compute(double d, double d2) {
        return d * d2;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBinaryExpression(this, "*", this.left, this.right);
    }

    public static int getOpcode(CType cType) {
        switch (cType.getTypeID()) {
            case 7: {
                return 106;
            }
            case 6: {
                return 105;
            }
            case 8: {
                return 107;
            }
        }
        return 104;
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        this.left.genCode(codeSequence, false);
        this.right.genCode(codeSequence, false);
        codeSequence.plantNoArgInstruction(JMultExpression.getOpcode(this.getType()));
        if (bl) {
            codeSequence.plantPopInstruction(this.getType());
        }
    }

    public JMultExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
    }
}

