/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.NumberParser;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JByteLiteral;
import at.dms.kjc.JCharLiteral;
import at.dms.kjc.JDoubleLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFloatLiteral;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.JShortLiteral;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;

public class JIntLiteral
extends JLiteral {
    private final boolean invert;
    private final int value;

    public JIntLiteral getOppositeLiteral() throws PositionedError {
        return new JIntLiteral(this.getTokenReference(), this.invert ? Integer.MIN_VALUE : -this.value);
    }

    public CType getType() {
        return CStdType.Integer;
    }

    public int intValue() {
        if (this.invert) {
            throw new InconsistencyException();
        }
        return this.value;
    }

    public boolean isDefault() {
        return this.value == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JIntLiteral[");
        if (this.invert) {
            stringBuffer.append("2147483648 (= 2^31)");
        } else {
            stringBuffer.append(this.value);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.check((CContext)cExpressionContext, !this.invert, KjcMessages.INVALID_INT_LITERAL, "2147483648 (= 2^31)");
        return this;
    }

    public boolean isAssignableTo(CType cType) {
        switch (cType.getTypeID()) {
            case 2: {
                return (byte)this.value == this.value;
            }
            case 3: {
                return (short)this.value == this.value;
            }
            case 4: {
                return (char)this.value == this.value;
            }
        }
        return CStdType.Integer.isAssignableTo(cType);
    }

    public JExpression convertType(CType cType, CExpressionContext cExpressionContext) {
        if (this.invert) {
            throw new InconsistencyException();
        }
        switch (cType.getTypeID()) {
            case 2: {
                return new JByteLiteral(this.getTokenReference(), (byte)this.value);
            }
            case 3: {
                return new JShortLiteral(this.getTokenReference(), (short)this.value);
            }
            case 4: {
                return new JCharLiteral(this.getTokenReference(), (char)this.value);
            }
            case 5: {
                return this;
            }
            case 6: {
                return new JLongLiteral(this.getTokenReference(), this.value);
            }
            case 7: {
                return new JFloatLiteral(this.getTokenReference(), this.value);
            }
            case 8: {
                return new JDoubleLiteral(this.getTokenReference(), this.value);
            }
            case 9: {
                if (cType != CStdType.String) {
                    throw new InconsistencyException("cannot convert from int to " + cType);
                }
                return new JStringLiteral(this.getTokenReference(), "" + this.value);
            }
        }
        throw new InconsistencyException("cannot convert from int to " + cType);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitIntLiteral(this.value);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value));
        }
    }

    public JIntLiteral(TokenReference tokenReference, String string) throws PositionedError {
        super(tokenReference);
        if (string.startsWith("0")) {
            try {
                this.value = NumberParser.decodeInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PositionedError(tokenReference, KjcMessages.INVALID_INT_LITERAL, (Object)string);
            }
            this.invert = false;
        } else {
            int n;
            try {
                n = NumberParser.decodeInt("-" + string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PositionedError(tokenReference, KjcMessages.INVALID_INT_LITERAL, (Object)string);
            }
            if (n == Integer.MIN_VALUE) {
                this.value = n;
                this.invert = true;
            } else {
                this.value = -n;
                this.invert = false;
            }
        }
    }

    public JIntLiteral(TokenReference tokenReference, int n) {
        super(tokenReference);
        this.value = n;
        this.invert = false;
    }
}

