/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.Compiler;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClass;
import at.dms.kjc.CClassType;
import at.dms.kjc.CCompilationUnit;
import at.dms.kjc.CCompilationUnitContext;
import at.dms.kjc.CMember;
import at.dms.kjc.JClassImport;
import at.dms.kjc.JPackageImport;
import at.dms.kjc.JPackageName;
import at.dms.kjc.JPhylum;
import at.dms.kjc.JTypeDeclaration;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcPrettyPrinter;
import at.dms.kjc.KjcVisitor;
import at.dms.kjc.Main;
import at.dms.util.Utils;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class JCompilationUnit
extends JPhylum {
    private JPackageName packageName;
    private JClassImport[] importedClasses;
    private JPackageImport[] importedPackages;
    private JTypeDeclaration[] typeDeclarations;
    private Hashtable allLoadedClasses = new Hashtable();
    private CCompilationUnit export;

    public String getPackageName() {
        Utils.assert(this.packageName != null);
        return this.packageName.getName();
    }

    public String getFileName() {
        return this.getTokenReference().getFile();
    }

    public void checkInterface(Compiler compiler) throws PositionedError {
        CClassType cClassType;
        Utils utils;
        this.export = new CCompilationUnit(this.packageName.getName(), this.importedClasses, this.importedPackages, this.allLoadedClasses);
        CCompilationUnitContext cCompilationUnitContext = new CCompilationUnitContext(compiler, this.export);
        int n = 0;
        while (n < this.importedClasses.length) {
            utils = this.importedClasses[n];
            cClassType = CClassType.lookup(((JClassImport)utils).getQualifiedName());
            try {
                cClassType.checkType(cCompilationUnitContext);
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
            CClassType cClassType2 = this.allLoadedClasses.put(((JClassImport)utils).getSimpleName(), cClassType);
            if (cClassType2 != null) {
                if (cClassType != cClassType2) {
                    compiler.reportTrouble(new PositionedError(this.getTokenReference(), KjcMessages.DUPLICATE_TYPE_NAME, (Object)cClassType.getIdent()));
                } else {
                    compiler.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.DUPLICATE_CLASS_IMPORT, (Object)((JClassImport)utils).getQualifiedName()));
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.typeDeclarations.length) {
            utils = this.typeDeclarations[n].getCClass();
            cClassType = this.allLoadedClasses.get(((CMember)utils).getIdent());
            if (cClassType == null) {
                this.allLoadedClasses.put(((CMember)utils).getIdent(), ((CClass)utils).getType());
            } else if (cClassType != utils) {
                compiler.reportTrouble(new PositionedError(this.getTokenReference(), KjcMessages.DUPLICATE_TYPE_NAME, (Object)((CClass)utils).getQualifiedName()));
            }
            ++n;
        }
        n = 0;
        while (n < this.typeDeclarations.length) {
            this.typeDeclarations[n].checkInterface(cCompilationUnitContext);
            ++n;
        }
    }

    public void checkInitializers(Compiler compiler, Vector vector) throws PositionedError {
        CCompilationUnitContext cCompilationUnitContext = new CCompilationUnitContext(compiler, this.export, vector);
        int n = 0;
        while (n < this.typeDeclarations.length) {
            this.typeDeclarations[n].checkInitializers(cCompilationUnitContext);
            ++n;
        }
    }

    public void checkBody(Compiler compiler, Vector vector) throws PositionedError {
        CCompilationUnitContext cCompilationUnitContext = new CCompilationUnitContext(compiler, this.export, vector);
        if (this.packageName == JPackageName.UNNAMED) {
            compiler.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.PACKAGE_IS_MISSING));
        }
        int n = 0;
        while (n < this.typeDeclarations.length) {
            this.typeDeclarations[n].checkTypeBody(cCompilationUnitContext);
            ++n;
        }
        n = 0;
        while (n < this.importedClasses.length) {
            this.importedClasses[n].analyse(compiler);
            ++n;
        }
        n = 0;
        while (n < this.importedPackages.length) {
            this.importedPackages[n].analyse(compiler, this.packageName);
            ++n;
        }
    }

    public void accept(Main main, String string) {
        KjcPrettyPrinter kjcPrettyPrinter;
        if (string == null || string.equals("")) {
            kjcPrettyPrinter = main.getPrettyPrinter(this.getTokenReference().getName() + ".gen");
            this.accept(kjcPrettyPrinter);
        } else {
            kjcPrettyPrinter = main.getPrettyPrinter(string + File.separatorChar + this.getTokenReference().getName());
            this.accept(kjcPrettyPrinter);
        }
        kjcPrettyPrinter.close();
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitCompilationUnit(this, this.packageName, this.importedPackages, this.importedClasses, this.typeDeclarations);
    }

    public JCompilationUnit(TokenReference tokenReference, JPackageName jPackageName, JPackageImport[] jPackageImportArray, JClassImport[] jClassImportArray, JTypeDeclaration[] jTypeDeclarationArray) {
        super(tokenReference);
        this.packageName = jPackageName;
        this.importedPackages = jPackageImportArray;
        this.importedClasses = jClassImportArray;
        this.typeDeclarations = jTypeDeclarationArray;
    }
}

