/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JBinaryArithmeticExpression;
import at.dms.kjc.JBooleanLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;

public class JBitwiseExpression
extends JBinaryArithmeticExpression {
    protected int oper;

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        try {
            this.type = JBitwiseExpression.computeType(this.left.getType(), this.right.getType());
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.left = this.left.convertType(this.type, cExpressionContext);
        this.right = this.right.convertType(this.type, cExpressionContext);
        if (this.left.isConstant() && this.right.isConstant()) {
            return this.constantFolding();
        }
        return this;
    }

    public static CType computeType(CType cType, CType cType2) throws UnpositionedError {
        if (cType == CStdType.Boolean && cType2 == CStdType.Boolean) {
            return CStdType.Boolean;
        }
        if (cType.isOrdinal() && cType2.isOrdinal()) {
            return CNumericType.binaryPromote(cType, cType2);
        }
        throw new UnpositionedError(KjcMessages.BITWISE_BADTYPE, cType, cType2);
    }

    public JExpression constantFolding() {
        if (this.left.getType() == CStdType.Boolean) {
            boolean bl = this.compute(this.left.booleanValue(), this.right.booleanValue());
            return new JBooleanLiteral(this.getTokenReference(), bl);
        }
        if (this.left.getType() == CStdType.Long) {
            long l = this.compute(this.left.longValue(), this.right.longValue());
            return new JLongLiteral(this.getTokenReference(), l);
        }
        if (this.left.getType() == CStdType.Integer) {
            int n = this.compute(this.left.intValue(), this.right.intValue());
            return new JIntLiteral(this.getTokenReference(), n);
        }
        throw new InconsistencyException();
    }

    public int compute(int n, int n2) {
        switch (this.oper) {
            case 9: {
                return n & n2;
            }
            case 11: {
                return n | n2;
            }
            case 10: {
                return n ^ n2;
            }
        }
        throw new InconsistencyException();
    }

    public long compute(long l, long l2) {
        switch (this.oper) {
            case 9: {
                return l & l2;
            }
            case 11: {
                return l | l2;
            }
            case 10: {
                return l ^ l2;
            }
        }
        throw new InconsistencyException();
    }

    public boolean compute(boolean bl, boolean bl2) {
        switch (this.oper) {
            case 9: {
                return bl & bl2;
            }
            case 11: {
                return bl | bl2;
            }
            case 10: {
                return bl ^ bl2;
            }
        }
        throw new InconsistencyException();
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitBitwiseExpression(this, this.oper, this.left, this.right);
    }

    public static int getOpcode(int n, CType cType) {
        if (cType == CStdType.Long) {
            switch (n) {
                case 9: {
                    return 127;
                }
                case 11: {
                    return 129;
                }
                case 10: {
                    return 131;
                }
            }
        } else {
            switch (n) {
                case 9: {
                    return 126;
                }
                case 11: {
                    return 128;
                }
                case 10: {
                    return 130;
                }
            }
        }
        return -1;
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        this.left.genCode(codeSequence, false);
        this.right.genCode(codeSequence, false);
        codeSequence.plantNoArgInstruction(JBitwiseExpression.getOpcode(this.oper, this.getType()));
        if (bl) {
            codeSequence.plantPopInstruction(this.getType());
        }
    }

    public JBitwiseExpression(TokenReference tokenReference, int n, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.oper = n;
    }
}

