/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CArrayType;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JArrayAccessExpression
extends JExpression {
    private JExpression prefix;
    private JExpression accessor;
    private CType type;

    public CType getType() {
        return this.type;
    }

    public boolean isInitialized(CExpressionContext cExpressionContext) {
        return true;
    }

    public void setInitialized(CExpressionContext cExpressionContext) {
    }

    public boolean isLValue(CExpressionContext cExpressionContext) {
        return true;
    }

    public String getIdent() {
        return ((CArrayType)this.prefix.getType()).getElementType() + "[]";
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.accessor = this.accessor.analyse(new CExpressionContext(cExpressionContext));
        this.check((CContext)cExpressionContext, this.accessor.getType().isAssignableTo(CStdType.Integer), KjcMessages.ARRAY_EXPRESSION_INT, this.accessor.getType());
        this.prefix = this.prefix.analyse(new CExpressionContext(cExpressionContext));
        this.check(cExpressionContext, this.prefix.getType().isArrayType(), KjcMessages.ARRAY_PREFIX);
        this.type = ((CArrayType)this.prefix.getType()).getElementType();
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitArrayAccessExpression(this, this.prefix, this.accessor);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        this.prefix.genCode(codeSequence, false);
        this.accessor.genCode(codeSequence, false);
        codeSequence.plantNoArgInstruction(this.type.getArrayLoadOpcode());
        if (bl) {
            codeSequence.plantPopInstruction(this.type);
        }
    }

    public void genStartStoreCode(CodeSequence codeSequence) {
        this.prefix.genCode(codeSequence, false);
        this.accessor.genCode(codeSequence, false);
    }

    public void genEndStoreCode(CodeSequence codeSequence, boolean bl) {
        if (!bl) {
            if (this.getType().getSize() == 2) {
                codeSequence.plantNoArgInstruction(94);
            } else if (this.type.getSize() == 1) {
                codeSequence.plantNoArgInstruction(91);
            }
        }
        codeSequence.plantNoArgInstruction(this.type.getArrayStoreOpcode());
    }

    public JArrayAccessExpression(TokenReference tokenReference, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference);
        this.prefix = jExpression;
        this.accessor = jExpression2;
    }
}

