/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassRefInstruction;
import at.dms.classfile.FieldRefInstruction;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.JumpInstruction;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LocalVarInstruction;
import at.dms.classfile.LocalVariableInfo;
import at.dms.classfile.MethodRefInstruction;
import at.dms.classfile.NewarrayInstruction;
import at.dms.classfile.NoArgInstruction;
import at.dms.kjc.CClassType;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.Constants;
import at.dms.kjc.JLocalVariable;
import at.dms.kjc.JReturnStatement;
import at.dms.kjc.JStatement;
import at.dms.kjc.JSynchronizedStatement;
import at.dms.kjc.JTryFinallyStatement;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.util.Stack;
import java.util.Vector;

public final class CodeSequence
extends Utils
implements Constants {
    private static final Stack stack = new Stack();
    private Instruction[] instructions;
    private Vector handlers;
    private Vector lines;
    private int pc;
    private boolean labelAtEnd;
    private int lineNumber;
    private int lastLine;
    private Stack contexts = new Stack();
    private static /* synthetic */ Class class$Lat$dms$classfile$LineNumberInfo;
    private static /* synthetic */ Class class$Lat$dms$classfile$HandlerInfo;

    public static CodeSequence getCodeSequence() {
        CodeSequence codeSequence = stack.empty() ? new CodeSequence() : (CodeSequence)stack.pop();
        codeSequence.pc = 0;
        codeSequence.labelAtEnd = false;
        codeSequence.lineNumber = 0;
        codeSequence.lastLine = -1;
        return codeSequence;
    }

    public void release() {
        stack.push(this);
        this.handlers.setSize(0);
        this.lines.setSize(0);
    }

    public static void endSession() {
        while (!stack.empty()) {
            stack.pop();
        }
    }

    public final void plantInstruction(Instruction instruction) {
        this.instructions[this.pc++] = instruction;
        this.labelAtEnd = false;
        if (this.lineNumber != this.lastLine) {
            this.lastLine = this.lineNumber;
            this.lines.addElement(new LineNumberInfo((short)this.lineNumber, instruction));
        }
    }

    public final void plantNoArgInstruction(int n) {
        this.plantInstruction(new NoArgInstruction(n));
    }

    public final void plantPopInstruction(CType cType) {
        switch (cType.getSize()) {
            case 0: {
                Utils.assert(cType == CStdType.Void);
                break;
            }
            case 1: {
                this.plantNoArgInstruction(87);
                break;
            }
            case 2: {
                this.plantNoArgInstruction(88);
                break;
            }
            default: {
                Utils.assert(false);
            }
        }
    }

    public final void plantLocalVar(int n, JLocalVariable jLocalVariable) {
        LocalVarInstruction localVarInstruction = new LocalVarInstruction(n, jLocalVariable.getPosition());
        this.plantInstruction(localVarInstruction);
        this.addLocalVarInfo(localVarInstruction, jLocalVariable);
    }

    public final void plantLoadThis() {
        this.plantInstruction(new LocalVarInstruction(25, 0));
    }

    public final void plantFieldRefInstruction(int n, String string, String string2, String string3) {
        this.plantInstruction(new FieldRefInstruction(n, string, string2, string3));
    }

    public final void plantMethodRefInstruction(int n, String string, String string2, String string3) {
        this.plantInstruction(new MethodRefInstruction(n, string, string2, string3));
    }

    public final void plantClassRefInstruction(int n, String string) {
        this.plantInstruction(new ClassRefInstruction(n, string));
    }

    public final void plantJumpInstruction(int n, CodeLabel codeLabel) {
        this.plantInstruction(new JumpInstruction(n, codeLabel));
    }

    public final void plantNewArrayInstruction(CType cType) {
        if (cType.isReference()) {
            this.plantClassRefInstruction(189, ((CClassType)cType).getQualifiedName());
        } else {
            byte by;
            switch (cType.getTypeID()) {
                case 2: {
                    by = 8;
                    break;
                }
                case 11: {
                    by = 4;
                    break;
                }
                case 4: {
                    by = 5;
                    break;
                }
                case 3: {
                    by = 9;
                    break;
                }
                case 5: {
                    by = 10;
                    break;
                }
                case 6: {
                    by = 11;
                    break;
                }
                case 7: {
                    by = 6;
                    break;
                }
                case 8: {
                    by = 7;
                    break;
                }
                default: {
                    throw new InconsistencyException();
                }
            }
            this.plantInstruction(new NewarrayInstruction(by));
        }
    }

    public final void plantLabel(CodeLabel codeLabel) {
        codeLabel.setAddress(this.pc);
        this.labelAtEnd = true;
    }

    public final void setLineNumber(int n) {
        if (n != 0) {
            this.lineNumber = n;
        }
    }

    public final LineNumberInfo[] getLineNumbers() {
        return (LineNumberInfo[])Utils.toArray(this.lines, class$Lat$dms$classfile$LineNumberInfo != null ? class$Lat$dms$classfile$LineNumberInfo : (class$Lat$dms$classfile$LineNumberInfo = CodeSequence.class$("at.dms.classfile.LineNumberInfo")));
    }

    public final LocalVariableInfo[] getLocalVariableInfos() {
        return null;
    }

    public final void plantReturn(JReturnStatement jReturnStatement) {
        int n = this.contexts.size() - 1;
        while (n >= 0) {
            JStatement jStatement = (JStatement)this.contexts.elementAt(n);
            if (jStatement instanceof JTryFinallyStatement) {
                ((JTryFinallyStatement)jStatement).genFinallyCall(this, jReturnStatement);
            } else if (jStatement instanceof JSynchronizedStatement) {
                ((JSynchronizedStatement)jStatement).genMonitorExit(this);
            }
            --n;
        }
    }

    public final void plantBreak(JStatement jStatement) {
        int n = this.contexts.size() - 1;
        while (n >= 0 && this.contexts.elementAt(n) != jStatement) {
            JStatement jStatement2 = (JStatement)this.contexts.elementAt(n);
            if (jStatement2 instanceof JTryFinallyStatement) {
                ((JTryFinallyStatement)jStatement2).genFinallyCall(this, null);
            } else if (jStatement2 instanceof JSynchronizedStatement) {
                ((JSynchronizedStatement)jStatement2).genMonitorExit(this);
            }
            --n;
        }
    }

    public final void pushContext(JStatement jStatement) {
        this.contexts.push(jStatement);
    }

    public final void popContext(JStatement jStatement) {
        Utils.assert((JStatement)this.contexts.pop() == jStatement);
    }

    public final void addExceptionHandler(int n, int n2, int n3, String string) {
        if (n != n2) {
            this.handlers.addElement(new HandlerInfo(this.getInstructionAt(n), this.getInstructionAt(n2 - 1), this.getInstructionAt(n3), string));
        }
    }

    public final HandlerInfo[] getHandlers() {
        return (HandlerInfo[])Utils.toArray(this.handlers, class$Lat$dms$classfile$HandlerInfo != null ? class$Lat$dms$classfile$HandlerInfo : (class$Lat$dms$classfile$HandlerInfo = CodeSequence.class$("at.dms.classfile.HandlerInfo")));
    }

    public final int getPC() {
        return this.pc;
    }

    public final int size() {
        return this.pc;
    }

    public final Instruction getInstructionAt(int n) {
        return this.instructions[n];
    }

    public Instruction[] getInstructionArray() {
        this.resolveLabels();
        Instruction[] instructionArray = new Instruction[this.pc];
        System.arraycopy(this.instructions, 0, instructionArray, 0, this.pc);
        return instructionArray;
    }

    private void resolveLabels() {
        if (this.labelAtEnd) {
            this.plantNoArgInstruction(0);
        }
        try {
            CodeSequence codeSequence = this;
            if (codeSequence == null) {
                throw null;
            }
            AccessorTransformer accessorTransformer = new AccessorTransformer(codeSequence){
                private final /* synthetic */ CodeSequence this$0;

                public InstructionAccessor transform(InstructionAccessor instructionAccessor, AccessorContainer accessorContainer) {
                    return this.this$0.getInstructionAt(((CodeLabel)instructionAccessor).getAddress());
                }
                {
                    this.this$0 = codeSequence;
                    this.constructor$0(codeSequence);
                }

                private final void constructor$0(CodeSequence codeSequence) {
                }
            };
            int n = 0;
            while (n < this.pc) {
                if (this.instructions[n] instanceof AccessorContainer) {
                    ((AccessorContainer)((Object)this.instructions[n])).transformAccessors(accessorTransformer);
                }
                ++n;
            }
        }
        catch (BadAccessorException badAccessorException) {
            throw new InconsistencyException();
        }
    }

    private final void addLocalVarInfo(LocalVarInstruction localVarInstruction, JLocalVariable jLocalVariable) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private CodeSequence() {
        this.instructions = new Instruction[65535];
        this.handlers = new Vector();
        this.lines = new Vector();
    }
}

