/*
 * Decompiled with CFR 0.152.
 */
package at.dms.ikjc;

import at.dms.ikjc.ClientOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class Client {
    private ClientOptions options;
    private Socket socket;
    private PrintWriter out;
    private BufferedReader in;

    public static void main(String[] stringArray) {
        boolean bl = new Client().run(stringArray);
        System.exit(bl ? 0 : 1);
    }

    public boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        if (!this.openConnection()) {
            return false;
        }
        this.sendArguments();
        boolean bl = this.processDiagnostics();
        this.closeConnection();
        return bl;
    }

    private boolean parseArguments(String[] stringArray) {
        this.options = new ClientOptions();
        return this.options.parseCommandLine(stringArray);
    }

    private boolean openConnection() {
        try {
            this.socket = new Socket(this.options.host, this.options.port);
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Host unknown: " + this.options.host);
            return false;
        }
        catch (IOException iOException) {
            System.err.println("Cannot connect to " + this.options.host + ":" + this.options.port + ". Is the server running ?");
            return false;
        }
    }

    private void closeConnection() {
        try {
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            System.err.println("An I/O error has occurred : " + iOException.getMessage());
        }
    }

    private void sendArguments() {
        this.out.println(System.getProperty("user.dir"));
        this.out.println(this.options.compiler);
        int n = 0;
        while (n < this.options.nonOptions.length) {
            this.out.println(this.options.nonOptions[n]);
            ++n;
        }
        this.out.println();
    }

    private boolean processDiagnostics() {
        try {
            String string;
            while ((string = this.in.readLine()) != null) {
                if (string.endsWith("!@#$%^&*()")) {
                    return new Boolean(this.in.readLine());
                }
                System.out.println(string);
            }
        }
        catch (IOException iOException) {
            System.err.println("An I/O error has occurred : " + iOException.getMessage());
            return false;
        }
        System.err.println("Unexpected end of connection");
        return false;
    }
}

